/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import org.opendaylight.mdsal.dom.schema.osgi.impl.YangModuleInfoRegistry;
import org.opendaylight.mdsal.dom.schema.osgi.impl.YangModuleInfoScanner;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class OSGiModelRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiModelRuntime.class);
    @Reference
    YangParserFactory parserFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.dom.schema.osgi.impl.OSGiEffectiveModelImpl)")
    ComponentFactory contextFactory = null;
    private YangModuleInfoScanner bundleTracker = null;
    private YangModuleInfoRegistry moduleRegistry = null;

    @Activate
    void activate(BundleContext ctx) {
        LOG.info("Model Runtime starting");
        this.moduleRegistry = YangModuleInfoRegistry.create(ctx, this.contextFactory, this.parserFactory);
        this.bundleTracker = new YangModuleInfoScanner(ctx, this.moduleRegistry);
        this.bundleTracker.open();
        this.moduleRegistry.enableScannerAndUpdate();
        LOG.info("Model Runtime started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Model Runtime stopping");
        this.moduleRegistry.close();
        this.bundleTracker.close();
        LOG.info("Model Runtime stopped");
    }
}

