/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.util.List;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.obr.command.ObrCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="obr", name="list", description="Lists OBR bundles, optionally providing the given packages.")
@Service
public class ListCommand
extends ObrCommandSupport {
    @Argument(index=0, name="packages", description="A list of packages separated by whitespaces.", required=false, multiValued=true)
    List<String> packages;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    void doExecute(RepositoryAdmin admin) throws Exception {
        StringBuilder substr = new StringBuilder();
        if (this.packages != null) {
            for (String packageName : this.packages) {
                substr.append(" ");
                substr.append(packageName);
            }
        }
        String query = substr == null || substr.length() == 0 ? "(|(presentationname=*)(symbolicname=*))" : "(|(presentationname=*" + substr + "*)(symbolicname=*" + substr + "*))";
        Resource[] resources = admin.discoverResources(query);
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Symbolic Name");
        table.column("Version");
        table.emptyTableText("No matching bundles");
        for (Resource resource : resources) {
            table.addRow().addContent(new Object[]{this.emptyIfNull(resource.getPresentationName()), this.emptyIfNull(resource.getSymbolicName()), this.emptyIfNull(resource.getVersion())});
        }
        table.print(System.out, !this.noFormat);
    }

    private String emptyIfNull(Object st) {
        return st == null ? "" : st.toString();
    }
}

