/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.IOException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractLithiumDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.codec.binfmt.QNameFactory;

final class LithiumNormalizedNodeInputStreamReader
extends AbstractLithiumDataInput {
    LithiumNormalizedNodeInputStreamReader(DataInput input) {
        super(input);
    }

    @Override
    public NormalizedNodeStreamVersion getVersion() {
        return NormalizedNodeStreamVersion.LITHIUM;
    }

    @Override
    public QName readQName() throws IOException {
        String localName = this.readCodedString();
        String namespace = this.readCodedString();
        String revision = Strings.emptyToNull((String)this.readCodedString());
        return QNameFactory.create(localName, namespace, revision);
    }

    @Override
    YangInstanceIdentifier.AugmentationIdentifier readAugmentationIdentifier() throws IOException {
        return this.defaultReadAugmentationIdentifier();
    }

    @Override
    YangInstanceIdentifier.NodeIdentifier readNodeIdentifier() throws IOException {
        return new YangInstanceIdentifier.NodeIdentifier(this.readQName());
    }
}

