/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.data.util;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.rfc7952.data.api.MetadataNormalizedAnydata;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.rfc7952.data.util.NormalizedMetadataWriter;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.ImmutableNormalizedAnydata;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

@Beta
@NonNullByDefault
public final class ImmutableMetadataNormalizedAnydata
extends ImmutableNormalizedAnydata
implements MetadataNormalizedAnydata {
    private final NormalizedMetadata metadata;

    public ImmutableMetadataNormalizedAnydata(EffectiveModelContext schemaContext, DataSchemaNode contextNode, NormalizedNode<?, ?> data, NormalizedMetadata metadata) {
        super(schemaContext, contextNode, data);
        this.metadata = Objects.requireNonNull(metadata);
    }

    public static ImmutableNormalizedAnydata ofOptional(EffectiveModelContext schemaContext, DataSchemaNode contextNode, NormalizedNode<?, ?> data, Optional<NormalizedMetadata> metadata) {
        return metadata.isPresent() ? new ImmutableMetadataNormalizedAnydata(schemaContext, contextNode, data, metadata.get()) : new ImmutableNormalizedAnydata(schemaContext, contextNode, data);
    }

    public NormalizedMetadata getMetadata() {
        return this.metadata;
    }

    public void writeTo(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) throws IOException {
        NormalizedMetadataWriter.forStreamWriter(writer, orderKeyLeaves).write(this.getData(), this.getMetadata()).flush();
    }
}

