/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.openconfig.parser;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigHashedValueEffectiveStatement;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigHashedValueStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseVoidStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

abstract class AbstractHashedValueStatementSupport
extends BaseVoidStatementSupport<OpenConfigHashedValueStatement, OpenConfigHashedValueEffectiveStatement> {
    private final SubstatementValidator validator;

    AbstractHashedValueStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).build();
    }

    protected final SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    protected final OpenConfigHashedValueStatement createDeclared(StmtContext<Void, OpenConfigHashedValueStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new Declared(this.getPublicView(), substatements);
    }

    protected final OpenConfigHashedValueStatement createEmptyDeclared(StmtContext<Void, OpenConfigHashedValueStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected final OpenConfigHashedValueEffectiveStatement createEffective(StmtContext<Void, OpenConfigHashedValueStatement, OpenConfigHashedValueEffectiveStatement> ctx, OpenConfigHashedValueStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new Effective(declared, substatements, ctx);
    }

    protected final OpenConfigHashedValueEffectiveStatement createEmptyEffective(StmtContext<Void, OpenConfigHashedValueStatement, OpenConfigHashedValueEffectiveStatement> ctx, OpenConfigHashedValueStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    private static final class Effective
    extends UnknownEffectiveStatementBase<Void, OpenConfigHashedValueStatement>
    implements OpenConfigHashedValueEffectiveStatement {
        private final @NonNull StatementDefinition definition;
        private final SchemaPath path;

        Effective(OpenConfigHashedValueStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, StmtContext<Void, OpenConfigHashedValueStatement, ?> ctx) {
            super((Object)((Void)declared.argument()), (UnknownStatement)declared, substatements, ctx);
            this.definition = ctx.getPublicDefinition();
            this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild(ctx.getPublicDefinition().getStatementName());
        }

        public QName getQName() {
            return this.path.getLastComponent();
        }

        @Deprecated
        public SchemaPath getPath() {
            return this.path;
        }

        public StatementDefinition statementDefinition() {
            return this.definition;
        }
    }

    private static final class Declared
    extends AbstractDeclaredStatement.WithoutArgument.WithSubstatements
    implements OpenConfigHashedValueStatement {
        private final @NonNull StatementDefinition definition;

        Declared(StatementDefinition definition, ImmutableList<? extends DeclaredStatement<?>> substatements) {
            super(substatements);
            this.definition = Objects.requireNonNull(definition);
        }

        public StatementDefinition statementDefinition() {
            return this.definition;
        }
    }
}

