/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yangtools.util.ConcurrentDurationStatisticsTracker;
import org.opendaylight.yangtools.util.DurationWithTime;
import org.opendaylight.yangtools.util.SynchronizedDurationStatsTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class DurationStatisticsTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DurationStatisticsTracker.class);
    private static final DecimalFormat DECIMAL_FORMAT;

    public static DurationStatisticsTracker createConcurrent() {
        return new ConcurrentDurationStatisticsTracker();
    }

    public static DurationStatisticsTracker createSynchronized() {
        return new SynchronizedDurationStatsTracker();
    }

    public abstract void addDuration(long var1);

    public abstract double getAverageDuration();

    public abstract long getTotalDurations();

    public abstract void reset();

    protected abstract DurationWithTime getShortest();

    protected abstract DurationWithTime getLongest();

    public final long getLongestDuration() {
        return DurationStatisticsTracker.getDuration(this.getLongest());
    }

    public final long getShortestDuration() {
        return DurationStatisticsTracker.getDuration(this.getShortest());
    }

    public final String getDisplayableAverageDuration() {
        return DurationStatisticsTracker.formatDuration(this.getAverageDuration(), null);
    }

    public final String getDisplayableLongestDuration() {
        return DurationStatisticsTracker.formatDuration(this.getLongest());
    }

    public final String getDisplayableShortestDuration() {
        return DurationStatisticsTracker.formatDuration(this.getShortest());
    }

    public final long getTimeOfLongestDuration() {
        return DurationStatisticsTracker.getTimeMillis(this.getLongest());
    }

    public final long getTimeOfShortestDuration() {
        return DurationStatisticsTracker.getTimeMillis(this.getShortest());
    }

    private static synchronized String formatDecimalValue(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    private static long getDuration(DurationWithTime current) {
        return current == null ? 0L : current.getDuration();
    }

    private static long getTimeMillis(DurationWithTime current) {
        return current == null ? 0L : current.getTimeMillis();
    }

    private static String formatDuration(double duration, Long timeStamp) {
        TimeUnit unit = DurationStatisticsTracker.chooseUnit((long)duration);
        double value = duration / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        StringBuilder sb = new StringBuilder();
        sb.append(DurationStatisticsTracker.formatDecimalValue(value));
        sb.append(' ');
        sb.append(DurationStatisticsTracker.abbreviate(unit));
        if (timeStamp != null) {
            sb.append(String.format(" at %1$tD %1$tT", new Date(timeStamp)));
        }
        return sb.toString();
    }

    private static String formatDuration(DurationWithTime current) {
        if (current == null) {
            return DurationStatisticsTracker.formatDuration(0.0, null);
        }
        return DurationStatisticsTracker.formatDuration(current.getDuration(), current.getTimeMillis());
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.NANOSECONDS.toSeconds(nanos) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.NANOSECONDS.toMillis(nanos) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.NANOSECONDS.toMicros(nanos) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        LOG.warn("Unhandled time unit {}", (Object)unit);
        return "";
    }

    static {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setDecimalSeparator('.');
        DECIMAL_FORMAT = new DecimalFormat("0.00", symbols);
    }
}

