/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;

public final class Immutables {
    private static final ImmutableSet<Class<?>> KNOWN_IMMUTABLES = ImmutableSet.of(Integer.class, Short.class, BigDecimal.class, BigInteger.class, Byte.class, Character.class, (Object[])new Class[]{Double.class, Float.class, String.class, Boolean.class, Void.class});

    private Immutables() {
    }

    public static boolean isImmutable(Object obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0, (Object)"Object should not be null");
        if (obj instanceof Mutable) {
            return false;
        }
        if (obj instanceof Immutable) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        return KNOWN_IMMUTABLES.contains(obj.getClass());
    }
}

