/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class UnmodifiableCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final @NonNull Class<?> UNMODIFIABLE_COLLECTION_CLASS = Collections.unmodifiableCollection(new ArrayList()).getClass();
    private static final @NonNull Collection<Class<?>> SINGLETON_CLASSES;
    private final @NonNull Collection<E> delegate;

    private UnmodifiableCollection(@NonNull Collection<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @SuppressModernizer
    public static <T> @NonNull Collection<T> create(@NonNull Collection<T> collection) {
        if (collection instanceof UnmodifiableCollection || collection instanceof ImmutableCollection || Collections.EMPTY_LIST == collection || Collections.EMPTY_SET == collection || UNMODIFIABLE_COLLECTION_CLASS.isInstance(collection) || SINGLETON_CLASSES.contains(collection.getClass())) {
            return collection;
        }
        return new UnmodifiableCollection<T>(collection);
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.delegate.iterator());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public @NonNull String toString() {
        return "UnmodifiableCollection{" + this.delegate + "}";
    }

    static {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.add(Collections.singleton(null).getClass());
        b.add(Collections.singletonList(null).getClass());
        SINGLETON_CLASSES = b.build();
    }
}

