/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.query;

import java.util.AbstractMap;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryResult;
import org.opendaylight.mdsal.dom.spi.query.DOMQueryMatcher;
import org.opendaylight.mdsal.dom.spi.query.LazyDOMQueryResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

@NonNullByDefault
public final class DOMQueryEvaluator {
    private DOMQueryEvaluator() {
    }

    public static DOMQueryResult evaluateOn(DOMQuery query, NormalizedNode<?, ?> queryRoot) {
        YangInstanceIdentifier path = query.getSelect();
        return path.isEmpty() ? DOMQueryEvaluator.evalSingle(query, queryRoot) : new LazyDOMQueryResult(query, queryRoot);
    }

    public static DOMQueryResult evaluateOnRoot(DOMQuery query, NormalizedNode<?, ?> root) {
        NormalizedNode evalRoot = root;
        for (YangInstanceIdentifier.PathArgument arg : query.getRoot().getPathArguments()) {
            Optional next = NormalizedNodes.findNode(root, (YangInstanceIdentifier.PathArgument)arg);
            if (next.isEmpty()) {
                return DOMQueryResult.of();
            }
            evalRoot = (NormalizedNode)next.orElseThrow();
        }
        return DOMQueryEvaluator.evaluateOn(query, evalRoot);
    }

    private static DOMQueryResult evalSingle(DOMQuery query, NormalizedNode<?, ?> data) {
        return DOMQueryMatcher.matchesAll(data, query.getPredicates()) ? DOMQueryResult.of() : DOMQueryResult.of(new AbstractMap.SimpleImmutableEntry(query.getRoot(), data));
    }
}

