/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListeningException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.shard.AbstractStateAggregator;
import org.opendaylight.mdsal.dom.spi.shard.CompatListenableDOMDataTreeShard;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
@Beta
public final class DOMDataTreeListenerAggregator
extends AbstractStateAggregator<State> {
    private static final Logger LOG = LoggerFactory.getLogger(DOMDataTreeListenerAggregator.class);
    private static final Executor FAILURE_NOTIFIER;
    private final boolean allowRxMerges;

    public DOMDataTreeListenerAggregator(int sizeHint, boolean allowRxMerges) {
        super(sizeHint);
        this.allowRxMerges = allowRxMerges;
    }

    public static <L extends DOMDataTreeListener, T> ListenerRegistration<L> aggregateIfNeeded(L listener, Map<T, Collection<DOMDataTreeIdentifier>> subtrees, boolean allowRxMerges, Function<T, DOMDataTreeShard> keyToShard) {
        if (subtrees.size() == 1) {
            Map.Entry<T, Collection<DOMDataTreeIdentifier>> entry = subtrees.entrySet().iterator().next();
            return CompatListenableDOMDataTreeShard.createIfNeeded(keyToShard.apply(entry.getKey())).registerListener(listener, entry.getValue(), allowRxMerges);
        }
        int size = subtrees.size();
        DOMDataTreeListenerAggregator aggregator = new DOMDataTreeListenerAggregator(size, allowRxMerges);
        ArrayList<ListenerRegistration<DOMDataTreeListener>> regs = new ArrayList<ListenerRegistration<DOMDataTreeListener>>(size);
        for (Map.Entry<T, Collection<DOMDataTreeIdentifier>> entry : subtrees.entrySet()) {
            regs.add((ListenerRegistration<DOMDataTreeListener>)CompatListenableDOMDataTreeShard.createIfNeeded(keyToShard.apply(entry.getKey())).registerListener(aggregator.createListener(), entry.getValue(), allowRxMerges));
        }
        return aggregator.start(listener, regs);
    }

    public DOMDataTreeListener createListener() {
        final StateBuilder builder = new StateBuilder();
        this.addBuilder(builder);
        return new DOMDataTreeListener(){

            public void onDataTreeFailed(Collection<DOMDataTreeListeningException> causes) {
                DOMDataTreeListenerAggregator.this.receiveState(builder, new Failure(causes));
            }

            public void onDataTreeChanged(Collection<DataTreeCandidate> changes, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees) {
                DOMDataTreeListenerAggregator.this.receiveState(builder, new Changes(changes, subtrees));
            }
        };
    }

    public <L extends DOMDataTreeListener> ListenerRegistration<L> start(L listener, final Collection<ListenerRegistration<DOMDataTreeListener>> regs) {
        AbstractStateAggregator.Started result = this.start(builders -> DOMDataTreeListenerAggregator.start(listener, regs, builders));
        if (result instanceof AbstractStateAggregator.Failed) {
            return new AbstractListenerRegistration<L>(listener){

                protected void removeRegistration() {
                }
            };
        }
        return new AbstractListenerRegistration<L>(listener){

            protected void removeRegistration() {
                regs.forEach(ListenerRegistration::close);
            }
        };
    }

    static AbstractStateAggregator.Started<State> start(DOMDataTreeListener listener, Collection<ListenerRegistration<DOMDataTreeListener>> regs, Collection<AbstractStateAggregator.StateBuilder<State>> builders) {
        ArrayList<DataTreeCandidate> changes = new ArrayList<DataTreeCandidate>();
        ArrayList<DOMDataTreeListeningException> failures = new ArrayList<DOMDataTreeListeningException>(0);
        ImmutableMap.Builder subtrees = ImmutableMap.builder();
        for (AbstractStateAggregator.StateBuilder<State> builder : builders) {
            DOMDataTreeListenerAggregator.collectState((State)builder.build(), changes, subtrees, failures);
        }
        if (!failures.isEmpty()) {
            regs.forEach(ListenerRegistration::close);
            FAILURE_NOTIFIER.execute(() -> listener.onDataTreeFailed((Collection)failures));
            return new AbstractStateAggregator.Failed<State>(builders);
        }
        if (!changes.isEmpty()) {
            DOMDataTreeListenerAggregator.callListener(listener, changes, subtrees.build());
        }
        return new Operational(builders, listener);
    }

    static void callListener(DOMDataTreeListener listener, Collection<DataTreeCandidate> changes, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees) {
        try {
            listener.onDataTreeChanged(changes, subtrees);
        }
        catch (Exception e) {
            LOG.error("Listener {} failed to process initial changes", (Object)listener, (Object)e);
        }
    }

    static void collectState(State state, Collection<DataTreeCandidate> changes, ImmutableMap.Builder<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees, Collection<DOMDataTreeListeningException> failures) {
        Verify.verify((boolean)(state instanceof Aggregated), (String)"Unexpected state %s", (Object)state);
        Aggregated aggregated = (Aggregated)state;
        subtrees.putAll(aggregated.subtrees);
        changes.addAll(aggregated.changes);
        failures.addAll(aggregated.failures);
    }

    static {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(DOMDataTreeListenerAggregator.class.getSimpleName() + "-failure-%s");
        FAILURE_NOTIFIER = Executors.newSingleThreadExecutor(tfb.build());
    }

    private static final class Operational
    extends AbstractStateAggregator.Operational<State> {
        private final DOMDataTreeListener listener;
        private boolean failed;

        Operational(Collection<AbstractStateAggregator.StateBuilder<State>> builders, DOMDataTreeListener listener) {
            super(builders);
            this.listener = Objects.requireNonNull(listener);
        }

        @Override
        protected void notifyListener(Iterator<State> iterator) {
            if (this.failed) {
                iterator.forEachRemaining(state -> LOG.debug("Listener {} failed, ignoring state {}", (Object)this.listener, state));
                return;
            }
            Stopwatch clock = Stopwatch.createStarted();
            ArrayList<DataTreeCandidate> changes = new ArrayList<DataTreeCandidate>();
            ArrayList<DOMDataTreeListeningException> failures = new ArrayList<DOMDataTreeListeningException>(0);
            ImmutableMap.Builder subtrees = ImmutableMap.builder();
            while (iterator.hasNext()) {
                DOMDataTreeListenerAggregator.collectState(iterator.next(), changes, subtrees, failures);
            }
            if (!changes.isEmpty()) {
                DOMDataTreeListenerAggregator.callListener(this.listener, changes, subtrees.build());
            }
            if (!failures.isEmpty()) {
                this.failed = true;
                this.listener.onDataTreeFailed(failures);
            }
            LOG.trace("Listener {} notification completed in {}", (Object)this.listener, (Object)clock);
        }
    }

    private static final class StateBuilder
    extends AbstractStateAggregator.StateBuilder<State> {
        private final @GuardedBy(value={"this"}) Collection<DOMDataTreeListeningException> causes = new ArrayList<DOMDataTreeListeningException>(0);
        private final @GuardedBy(value={"this"}) Collection<DataTreeCandidate> changes = new ArrayList<DataTreeCandidate>();
        private @GuardedBy(value={"this"}) Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees = ImmutableMap.of();

        private StateBuilder() {
        }

        @Override
        protected synchronized void append(State state) {
            if (state instanceof Changes) {
                Changes changesState = (Changes)state;
                this.changes.addAll(changesState.changes);
                this.subtrees = ImmutableMap.copyOf(changesState.subtrees);
            } else if (state instanceof Failure) {
                this.causes.addAll(((Failure)state).causes);
            } else {
                throw new IllegalStateException("Unexpected state " + state);
            }
        }

        @Override
        protected synchronized void appendInitial(State state) {
            if (state instanceof Changes) {
                Changes changesState = (Changes)state;
                this.changes.addAll(changesState.changes);
                this.subtrees = ImmutableMap.copyOf(changesState.subtrees);
            } else if (state instanceof Failure) {
                this.causes.addAll(((Failure)state).causes);
            } else {
                throw new IllegalStateException("Unexpected state " + state);
            }
        }

        public synchronized Aggregated build() {
            Aggregated ret = new Aggregated((Collection<DataTreeCandidate>)ImmutableList.copyOf(this.changes), this.subtrees, (Collection<DOMDataTreeListeningException>)ImmutableList.copyOf(this.causes));
            this.changes.clear();
            this.causes.clear();
            return ret;
        }
    }

    private static final class Failure
    extends State {
        final Collection<DOMDataTreeListeningException> causes;

        Failure(Collection<DOMDataTreeListeningException> causes) {
            this.causes = Objects.requireNonNull(causes);
        }
    }

    private static final class Changes
    extends State {
        final Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees;
        final Collection<DataTreeCandidate> changes;

        Changes(Collection<DataTreeCandidate> changes, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees) {
            this.changes = Objects.requireNonNull(changes);
            this.subtrees = Objects.requireNonNull(subtrees);
        }
    }

    private static final class Aggregated
    extends State {
        final Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees;
        final Collection<DOMDataTreeListeningException> failures;
        final Collection<DataTreeCandidate> changes;

        Aggregated(Collection<DataTreeCandidate> changes, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees, Collection<DOMDataTreeListeningException> failures) {
            this.changes = Objects.requireNonNull(changes);
            this.subtrees = Objects.requireNonNull(subtrees);
            this.failures = Objects.requireNonNull(failures);
        }
    }

    static abstract class State
    extends AbstractStateAggregator.State {
        State() {
        }
    }
}

