/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
@Beta
public final class ForeignShardModificationContext
implements Identifiable<DOMDataTreeIdentifier>,
Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignShardModificationContext.class);
    private final DOMDataTreeIdentifier identifier;
    private final DOMDataTreeShardProducer producer;
    private DOMDataTreeShardWriteTransaction tx;
    private DOMDataTreeWriteCursor cursor;
    private volatile boolean ready = false;

    public ForeignShardModificationContext(DOMDataTreeIdentifier identifier, DOMDataTreeShardProducer producer) {
        this.identifier = Objects.requireNonNull(identifier);
        this.producer = Objects.requireNonNull(producer);
    }

    public DOMDataTreeWriteCursor getCursor() {
        Preconditions.checkState((!this.ready ? 1 : 0) != 0, (String)"Context %s has been readied", (Object)this);
        if (this.cursor == null) {
            if (this.tx == null) {
                this.tx = this.producer.createTransaction();
            }
            this.cursor = this.tx.createCursor(this.getIdentifier());
        }
        return this.cursor;
    }

    public boolean isModified() {
        return this.tx != null;
    }

    public void ready() {
        if (this.ready) {
            LOG.debug("Duplicate ready() of context {}", (Object)this);
            return;
        }
        this.ready = true;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        if (this.tx != null) {
            this.tx.ready();
        }
    }

    public DOMDataTreeIdentifier getIdentifier() {
        return this.identifier;
    }

    public DOMDataTreeShardProducer getProducer() {
        return this.producer;
    }

    public ListenableFuture<Boolean> validate() {
        return this.tx.validate();
    }

    public ListenableFuture<Void> prepare() {
        return this.tx.prepare();
    }

    public ListenableFuture<Void> submit() {
        Preconditions.checkState((boolean)this.ready, (String)"Modification context %s has to be ready before submit", (Object)this);
        ListenableFuture<Void> commit = this.tx.commit();
        this.ready = false;
        this.tx = null;
        return commit;
    }

    public void closeForeignTransaction() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        if (this.tx != null) {
            this.tx.close();
            this.tx = null;
        }
    }
}

