/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
@Beta
public class ForeignShardThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignShardThreePhaseCommitCohort.class);
    private final DOMDataTreeIdentifier prefix;
    private final ForeignShardModificationContext shard;

    public ForeignShardThreePhaseCommitCohort(DOMDataTreeIdentifier prefix, ForeignShardModificationContext shard) {
        this.prefix = Objects.requireNonNull(prefix);
        this.shard = Objects.requireNonNull(shard);
    }

    @Override
    public ListenableFuture<Boolean> canCommit() {
        LOG.debug("Validating transaction on foreign shard {}", (Object)this.prefix);
        return this.shard.isModified() ? this.shard.validate() : FluentFutures.immediateTrueFluentFuture();
    }

    @Override
    public ListenableFuture<Void> preCommit() {
        LOG.debug("Preparing transaction on foreign shard {}", (Object)this.prefix);
        return this.shard.isModified() ? this.shard.prepare() : FluentFutures.immediateNullFluentFuture();
    }

    @Override
    public ListenableFuture<Void> abort() {
        LOG.debug("Aborting transaction of foreign shard {}", (Object)this.prefix);
        this.shard.closeForeignTransaction();
        return FluentFutures.immediateNullFluentFuture();
    }

    @Override
    public ListenableFuture<Void> commit() {
        LOG.debug("Submitting transaction on foreign shard {}", (Object)this.prefix);
        return this.shard.isModified() ? this.shard.submit() : FluentFutures.immediateNullFluentFuture();
    }
}

