/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.DelegatingWriteCursorStrategy;
import org.opendaylight.mdsal.dom.spi.shard.WriteCursorStrategy;
import org.opendaylight.mdsal.dom.spi.shard.WriteableModificationNode;
import org.opendaylight.mdsal.dom.spi.shard.WriteableSubshardBoundaryNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;

@Deprecated(forRemoval=true)
@Beta
public abstract class WritableNodeOperation
implements WriteCursorStrategy {
    private final WriteableModificationNode node;
    private final DOMDataTreeWriteCursor cursor;

    protected WritableNodeOperation(WriteableModificationNode node, DOMDataTreeWriteCursor cursor) {
        this.node = Objects.requireNonNull(node);
        this.cursor = Objects.requireNonNull(cursor);
    }

    protected final DOMDataTreeWriteCursor getCursor() {
        return this.cursor;
    }

    private void delete(YangInstanceIdentifier.PathArgument arg, WriteableModificationNode potentialChild) {
        this.cursor.delete(arg);
        if (potentialChild != null) {
            potentialChild.markDeleted();
        }
    }

    @Override
    public final void delete(YangInstanceIdentifier.PathArgument arg) {
        this.delete(arg, this.node.getChild(arg));
    }

    @Override
    public final void merge(YangInstanceIdentifier.PathArgument arg, NormalizedNode<?, ?> data) {
        WriteableModificationNode potentialChild = this.node.getChild(arg);
        if (potentialChild == null) {
            this.cursor.merge(arg, data);
        } else {
            potentialChild.createOperation(this.cursor).mergeToCurrent((NormalizedNodeContainer)data);
        }
    }

    @Override
    public final void write(YangInstanceIdentifier.PathArgument arg, NormalizedNode<?, ?> data) {
        WriteableModificationNode potentialChild = this.node.getChild(arg);
        if (potentialChild == null) {
            this.cursor.write(arg, data);
        } else {
            potentialChild.createOperation(this.cursor).writeToCurrent((NormalizedNodeContainer)data);
        }
    }

    @Override
    public final WriteCursorStrategy enter(YangInstanceIdentifier.PathArgument arg) {
        this.cursor.enter(arg);
        WriteableModificationNode child = this.node.getChild(arg);
        if (child != null) {
            return child.createOperation(this.cursor);
        }
        return new DelegatingWriteCursorStrategy(){

            @Override
            protected DOMDataTreeWriteCursor delegate() {
                return WritableNodeOperation.this.cursor;
            }
        };
    }

    @Override
    public final void mergeToCurrent(NormalizedNodeContainer<?, ?, ?> data) {
        for (NormalizedNode child : data.getValue()) {
            YangInstanceIdentifier.PathArgument childId = child.getIdentifier();
            WriteableModificationNode shardChild = this.node.getChild(childId);
            if (shardChild != null) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            this.cursor.merge(childId, child);
        }
    }

    @Override
    public final void writeToCurrent(NormalizedNodeContainer<?, ?, ?> data) {
        this.write(data.getIdentifier(), (NormalizedNode<?, ?>)data);
        this.cursor.enter(data.getIdentifier());
        for (NormalizedNode writtenChild : data.getValue()) {
            this.write(writtenChild.getIdentifier(), writtenChild);
        }
        this.node.getChildrenWithSubshards().entrySet().stream().filter(entry -> entry.getValue() instanceof WriteableSubshardBoundaryNode).forEach(entry -> {
            Optional writtenValue = data.getChild((YangInstanceIdentifier.PathArgument)entry.getKey());
            if (writtenValue.isPresent()) {
                this.cursor.delete((YangInstanceIdentifier.PathArgument)entry.getKey());
            }
        });
        this.cursor.exit();
    }
}

