/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.store;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SnapshotBackedWriteTransaction<T>
extends AbstractDOMStoreTransaction<T>
implements DOMStoreWriteTransaction,
SnapshotBackedTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotBackedWriteTransaction.class);
    private static final AtomicReferenceFieldUpdater<SnapshotBackedWriteTransaction, TransactionReadyPrototype> READY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SnapshotBackedWriteTransaction.class, TransactionReadyPrototype.class, "readyImpl");
    private static final AtomicReferenceFieldUpdater<SnapshotBackedWriteTransaction, DataTreeModification> TREE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SnapshotBackedWriteTransaction.class, DataTreeModification.class, "mutableTree");
    private volatile TransactionReadyPrototype<T> readyImpl;
    private volatile DataTreeModification mutableTree;

    SnapshotBackedWriteTransaction(T identifier, boolean debug, DataTreeSnapshot snapshot, TransactionReadyPrototype<T> readyImpl) {
        super(identifier, debug);
        this.readyImpl = Objects.requireNonNull(readyImpl, "readyImpl must not be null.");
        this.mutableTree = snapshot.newModification();
        LOG.debug("Write Tx: {} allocated with snapshot {}", identifier, (Object)snapshot);
    }

    @Override
    public void write(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkNotReady();
        DataTreeModification tree = this.mutableTree;
        LOG.debug("Tx: {} Write: {}:{}", new Object[]{this.getIdentifier(), path, data});
        try {
            tree.write(path, data);
        }
        catch (Exception e) {
            LOG.error("Tx: {}, failed to write {}:{} in {}", new Object[]{this.getIdentifier(), path, data, tree, e});
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalArgumentException("Illegal input data.", e);
        }
    }

    @Override
    public void merge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkNotReady();
        DataTreeModification tree = this.mutableTree;
        LOG.debug("Tx: {} Merge: {}:{}", new Object[]{this.getIdentifier(), path, data});
        try {
            tree.merge(path, data);
        }
        catch (Exception e) {
            LOG.error("Tx: {}, failed to merge {}:{} in {}", new Object[]{this.getIdentifier(), path, data, tree, e});
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalArgumentException("Illegal input data.", e);
        }
    }

    @Override
    public void delete(YangInstanceIdentifier path) {
        this.checkNotReady();
        DataTreeModification tree = this.mutableTree;
        LOG.debug("Tx: {} Delete: {}", this.getIdentifier(), (Object)path);
        try {
            tree.delete(path);
        }
        catch (Exception e) {
            LOG.error("Tx: {}, failed to delete {} in {}", new Object[]{this.getIdentifier(), path, tree, e});
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalArgumentException("Illegal path to delete.", e);
        }
    }

    final Optional<NormalizedNode<?, ?>> readSnapshotNode(YangInstanceIdentifier path) {
        return this.readyImpl == null ? null : this.mutableTree.readNode(path);
    }

    private void checkNotReady() {
        Preconditions.checkState((this.readyImpl != null ? 1 : 0) != 0, (String)"Transaction %s is no longer open. No further modifications allowed.", this.getIdentifier());
    }

    @Override
    public DOMStoreThreePhaseCommitCohort ready() {
        TransactionReadyPrototype wasReady = READY_UPDATER.getAndSet(this, null);
        Preconditions.checkState((wasReady != null ? 1 : 0) != 0, (String)"Transaction %s is no longer open", this.getIdentifier());
        LOG.debug("Store transaction: {} : Ready", this.getIdentifier());
        DataTreeModification tree = this.mutableTree;
        TREE_UPDATER.lazySet(this, null);
        try {
            tree.ready();
            return wasReady.transactionReady(this, tree, null);
        }
        catch (RuntimeException e) {
            LOG.debug("Store transaction: {}: unexpected failure when readying", this.getIdentifier(), (Object)e);
            return wasReady.transactionReady(this, tree, e);
        }
    }

    @Override
    public void close() {
        TransactionReadyPrototype wasReady = READY_UPDATER.getAndSet(this, null);
        if (wasReady != null) {
            LOG.debug("Store transaction: {} : Closed", this.getIdentifier());
            TREE_UPDATER.lazySet(this, null);
            wasReady.transactionAborted(this);
        } else {
            LOG.debug("Store transaction: {} : Closed after submit", this.getIdentifier());
        }
    }

    @Override
    public Optional<DataTreeSnapshot> getSnapshot() {
        return this.readyImpl == null ? Optional.empty() : Optional.ofNullable(this.mutableTree);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("ready", this.readyImpl == null);
    }

    public static abstract class TransactionReadyPrototype<T> {
        protected abstract void transactionAborted(SnapshotBackedWriteTransaction<T> var1);

        protected abstract DOMStoreThreePhaseCommitCohort transactionReady(SnapshotBackedWriteTransaction<T> var1, DataTreeModification var2, @Nullable Exception var3);
    }
}

