/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.xpath.antlr.instanceIdentifierParser;
import org.opendaylight.yangtools.yang.xpath.antlr.xpathLexer;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathMode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.impl.CapturingErrorListener;
import org.opendaylight.yangtools.yang.xpath.impl.FunctionSupport;
import org.opendaylight.yangtools.yang.xpath.impl.ParseTreeUtils;

abstract class InstanceIdentifierParser {
    private final YangXPathMathSupport mathSupport;

    InstanceIdentifierParser(YangXPathMathMode mathMode) {
        this.mathSupport = mathMode.getSupport();
    }

    final YangLocationPath.Absolute interpretAsInstanceIdentifier(YangLiteralExpr expr) throws XPathExpressionException {
        xpathLexer lexer = new xpathLexer((CharStream)CharStreams.fromString((String)expr.getLiteral()));
        instanceIdentifierParser parser = new instanceIdentifierParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        CapturingErrorListener listener = new CapturingErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        instanceIdentifierParser.InstanceIdentifierContext id = parser.instanceIdentifier();
        listener.reportError();
        int length = id.getChildCount();
        ArrayList<YangLocationPath.QNameStep> steps = new ArrayList<YangLocationPath.QNameStep>(length / 2);
        for (int i = 1; i < length; i += 2) {
            steps.add(this.parsePathArgument(ParseTreeUtils.getChild((ParseTree)id, instanceIdentifierParser.PathArgumentContext.class, i)));
        }
        return YangLocationPath.absolute(steps);
    }

    abstract YangQNameExpr createExpr(String var1, String var2);

    abstract YangLocationPath.QNameStep createChildStep(String var1, String var2, Collection<YangExpr> var3);

    private YangLocationPath.QNameStep parsePathArgument(instanceIdentifierParser.PathArgumentContext expr) {
        instanceIdentifierParser.NodeIdentifierContext childExpr = ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.NodeIdentifierContext.class, 0);
        String prefix = InstanceIdentifierParser.verifyIdentifier(childExpr, 0);
        String localName = InstanceIdentifierParser.verifyIdentifier(childExpr, 2);
        switch (expr.getChildCount()) {
            case 1: {
                return this.createChildStep(prefix, localName, (Collection<YangExpr>)ImmutableSet.of());
            }
            case 2: {
                return this.createChildStep(prefix, localName, this.parsePredicate(ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.PredicateContext.class, 1)));
            }
        }
        throw ParseTreeUtils.illegalShape((ParseTree)expr);
    }

    private Collection<YangExpr> parsePredicate(instanceIdentifierParser.PredicateContext expr) {
        ParseTree first = expr.getChild(0);
        if (first instanceof instanceIdentifierParser.LeafListPredicateContext) {
            return ImmutableSet.of((Object)YangBinaryOperator.EQUALS.exprWith((YangExpr)YangLocationPath.self(), (YangExpr)InstanceIdentifierParser.parseEqStringValue(ParseTreeUtils.getChild(((instanceIdentifierParser.LeafListPredicateContext)first).getChild(instanceIdentifierParser.LeafListPredicateExprContext.class, 0), instanceIdentifierParser.EqQuotedStringContext.class, 1))));
        }
        if (first instanceof instanceIdentifierParser.PosContext) {
            return ImmutableSet.of((Object)YangBinaryOperator.EQUALS.exprWith((YangExpr)FunctionSupport.POSITION, (YangExpr)this.mathSupport.createNumber(((instanceIdentifierParser.PosContext)first).getToken(10, 0).getText())));
        }
        int length = expr.getChildCount();
        ArrayList<YangExpr> ret = new ArrayList<YangExpr>(length);
        for (int i = 0; i < length; ++i) {
            instanceIdentifierParser.KeyPredicateExprContext pred = (instanceIdentifierParser.KeyPredicateExprContext)ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.KeyPredicateContext.class, i).getChild(instanceIdentifierParser.KeyPredicateExprContext.class, 0);
            ret.add((YangExpr)YangBinaryOperator.EQUALS.exprWith((YangExpr)this.createChildExpr(ParseTreeUtils.getChild((ParseTree)pred, instanceIdentifierParser.NodeIdentifierContext.class, 0)), (YangExpr)InstanceIdentifierParser.parseEqStringValue(ParseTreeUtils.getChild((ParseTree)pred, instanceIdentifierParser.EqQuotedStringContext.class, 1))));
        }
        return ret;
    }

    private YangQNameExpr createChildExpr(instanceIdentifierParser.NodeIdentifierContext expr) {
        return this.createExpr(InstanceIdentifierParser.verifyIdentifier(expr, 0), InstanceIdentifierParser.verifyIdentifier(expr, 2));
    }

    private static String verifyIdentifier(instanceIdentifierParser.NodeIdentifierContext expr, int child) {
        return ParseTreeUtils.verifyToken((ParseTree)expr, child, 9).getText();
    }

    private static YangLiteralExpr parseEqStringValue(instanceIdentifierParser.EqQuotedStringContext expr) {
        return YangLiteralExpr.of((String)ParseTreeUtils.verifyToken((ParseTree)ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.QuotedStringContext.class, expr.getChildCount() - 1), 1, 11).getText());
    }

    static final class Qualified
    extends InstanceIdentifierParser {
        final YangNamespaceContext namespaceContext;

        Qualified(YangXPathMathMode mathMode, YangNamespaceContext namespaceContext) {
            super(mathMode);
            this.namespaceContext = Objects.requireNonNull(namespaceContext);
        }

        @Override
        YangLocationPath.QNameStep createChildStep(String prefix, String localName, Collection<YangExpr> predicates) {
            return YangXPathAxis.CHILD.asStep(this.namespaceContext.createQName(prefix, localName), predicates);
        }

        @Override
        YangQNameExpr createExpr(String prefix, String localName) {
            return YangQNameExpr.of((QName)this.namespaceContext.createQName(prefix, localName));
        }
    }

    static final class Base
    extends InstanceIdentifierParser {
        Base(YangXPathMathMode mathMode) {
            super(mathMode);
        }

        @Override
        YangQNameExpr createExpr(String prefix, String localName) {
            return YangQNameExpr.of((UnresolvedQName)UnresolvedQName.qualified((String)prefix, (String)localName));
        }

        @Override
        YangLocationPath.QNameStep createChildStep(String prefix, String localName, Collection<YangExpr> predicates) {
            return YangXPathAxis.CHILD.asStep((UnresolvedQName)UnresolvedQName.qualified((String)prefix, (String)localName), predicates);
        }
    }
}

