/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.Transaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainListener;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.util.Datastore;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedConsumer;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedFunction;
import org.opendaylight.mdsal.binding.util.ManagedNewTransactionRunner;
import org.opendaylight.mdsal.binding.util.ManagedTransactionChain;
import org.opendaylight.mdsal.binding.util.ManagedTransactionChainImpl;
import org.opendaylight.mdsal.binding.util.ManagedTransactionFactoryImpl;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedWriteTransaction;
import org.opendaylight.mdsal.binding.util.WriteTrackingTransaction;
import org.opendaylight.mdsal.binding.util.WriteTrackingTypedReadWriteTransactionImpl;
import org.opendaylight.mdsal.binding.util.WriteTrackingTypedWriteTransactionImpl;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ManagedNewTransactionRunnerImpl
extends ManagedTransactionFactoryImpl<DataBroker>
implements ManagedNewTransactionRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedNewTransactionRunnerImpl.class);

    @Inject
    public ManagedNewTransactionRunnerImpl(DataBroker broker) {
        super(Objects.requireNonNull(broker, "broker must not be null"));
    }

    @Override
    @CheckReturnValue
    public <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> txFunction) {
        return super.applyWithNewTransactionAndSubmit(datastoreType, () -> ((DataBroker)((DataBroker)this.getTransactionFactory())).newReadWriteTransaction(), WriteTrackingTypedReadWriteTransactionImpl::new, txFunction::apply, this::commit);
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public <R> R applyWithNewTransactionChainAndClose(Function<ManagedTransactionChain, R> chainConsumer) {
        try (TransactionChain realTxChain = ((DataBroker)this.getTransactionFactory()).createTransactionChain(new TransactionChainListener(){

            public void onTransactionChainFailed(TransactionChain chain, Transaction transaction, Throwable cause) {
                LOG.error("Error handling a transaction chain", cause);
            }

            public void onTransactionChainSuccessful(TransactionChain chain) {
            }
        });){
            R r = chainConsumer.apply(new ManagedTransactionChainImpl(realTxChain));
            return r;
        }
    }

    @Override
    @CheckReturnValue
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewTransactionAndSubmit(datastoreType, () -> ((DataBroker)((DataBroker)this.getTransactionFactory())).newReadWriteTransaction(), WriteTrackingTypedReadWriteTransactionImpl::new, txConsumer::accept, this::commit);
    }

    @Override
    @CheckReturnValue
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewWriteOnlyTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> txConsumer) {
        return super.callWithNewTransactionAndSubmit(datastoreType, () -> ((DataBroker)((DataBroker)this.getTransactionFactory())).newWriteOnlyTransaction(), WriteTrackingTypedWriteTransactionImpl::new, txConsumer::accept, this::commit);
    }

    @CheckReturnValue
    private FluentFuture<? extends CommitInfo> commit(WriteTransaction realTx, WriteTrackingTransaction wrappedTx) {
        if (wrappedTx.isWritten()) {
            return realTx.commit();
        }
        realTx.cancel();
        return CommitInfo.emptyFluentFuture();
    }
}

