/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProgressTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressTracker.class);
    private final long defaultTicksPerTask;
    private long tasksClosed = 0L;
    private long tasksEncountered = 0L;
    private long lastIdle = Long.MIN_VALUE;
    private long lastClosed = Long.MIN_VALUE;
    private long nearestAllowed = Long.MIN_VALUE;
    private long elapsedBeforeIdle = 0L;

    ProgressTracker(long ticksPerTask) {
        Preconditions.checkArgument((ticksPerTask >= 0L ? 1 : 0) != 0);
        this.defaultTicksPerTask = ticksPerTask;
    }

    ProgressTracker(ProgressTracker oldTracker, long now) {
        this.defaultTicksPerTask = oldTracker.defaultTicksPerTask;
        this.tasksEncountered = this.tasksClosed = oldTracker.tasksClosed;
        this.lastClosed = oldTracker.lastClosed;
        this.nearestAllowed = oldTracker.nearestAllowed;
        this.lastIdle = oldTracker.lastIdle;
        this.elapsedBeforeIdle = oldTracker.elapsedBeforeIdle;
        if (!oldTracker.isIdle()) {
            this.transitToIdle(now);
        }
    }

    final long tasksClosed() {
        return this.tasksClosed;
    }

    final long tasksEncountered() {
        return this.tasksEncountered;
    }

    final long tasksOpen() {
        return this.tasksEncountered - this.tasksClosed;
    }

    final boolean isIdle() {
        return this.tasksClosed >= this.tasksEncountered;
    }

    final long ticksStalling(long now) {
        return this.isIdle() ? 0L : Math.max(now, this.lastClosed) - this.lastClosed;
    }

    protected final long defaultTicksPerTask() {
        return this.defaultTicksPerTask;
    }

    protected final double ticksWorkedPerClosedTask(long now) {
        if (this.tasksClosed < 1L) {
            return this.defaultTicksPerTask;
        }
        return (double)this.ticksWorked(now) / (double)this.tasksClosed;
    }

    private long ticksWorked(long now) {
        return this.isIdle() ? this.elapsedBeforeIdle : Math.max(now, this.lastIdle) - this.lastIdle + this.elapsedBeforeIdle;
    }

    private long estimateAllowed(long now) {
        return Math.max(now, this.nearestAllowed + this.estimateIsolatedDelay(now));
    }

    final void closeTask(long now, long enqueuedTicks, long transmitTicks, long execNanos) {
        if (this.isIdle()) {
            LOG.info("Attempted to close a task while no tasks are open");
        } else {
            this.unsafeCloseTask(now, enqueuedTicks, transmitTicks, execNanos);
        }
    }

    final long openTask(long now) {
        this.openTaskWithoutThrottle(now);
        return this.reserveDelay(now);
    }

    final void cancelDebt(long now) {
        this.nearestAllowed = now;
    }

    private long reserveDelay(long now) {
        this.nearestAllowed = this.estimateAllowed(now);
        return this.nearestAllowed - now;
    }

    private void unsafeCloseTask(long now, long enqueuedTicks, long transmitTicks, long execNanos) {
        ++this.tasksClosed;
        this.lastClosed = now;
        if (this.isIdle()) {
            this.transitToIdle(now);
        }
    }

    private void openTaskWithoutThrottle(long now) {
        if (this.isIdle()) {
            this.transitFromIdle(now);
        }
        ++this.tasksEncountered;
    }

    private void transitFromIdle(long now) {
        this.lastIdle = Math.max(now, this.lastIdle);
    }

    private void transitToIdle(long now) {
        this.elapsedBeforeIdle += Math.max(0L, now - this.lastIdle);
    }

    protected abstract long estimateIsolatedDelay(long var1);
}

