/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.SchemaTreeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public abstract class AbstractSchemaTreeStatementSupport<D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>>
extends AbstractQNameStatementSupport<D, E> {
    private static final StatementSupport.StatementPolicy<QName, ?> INSTANTIATED_POLICY = StatementSupport.StatementPolicy.copyDeclared(new SchemaTreeEquality.Instantiated());
    private static final StatementSupport.StatementPolicy<QName, ?> UNINSTANTIATED_POLICY = StatementSupport.StatementPolicy.copyDeclared(new SchemaTreeEquality());

    protected AbstractSchemaTreeStatementSupport(StatementDefinition publicDefinition, StatementSupport.StatementPolicy<QName, D> policy, YangParserConfiguration config, @Nullable SubstatementValidator validator) {
        super(publicDefinition, policy, config, validator);
    }

    public static final <D extends DeclaredStatement<QName>> StatementSupport.StatementPolicy<QName, D> instantiatedPolicy() {
        return INSTANTIATED_POLICY;
    }

    public static final <D extends DeclaredStatement<QName>> StatementSupport.StatementPolicy<QName, D> uninstantiatedPolicy() {
        return UNINSTANTIATED_POLICY;
    }

    @Override
    public void onStatementAdded(StmtContext.Mutable<QName, D, E> stmt) {
        stmt.coerceParentContext().addToNs(SchemaTreeNamespace.class, (QName)stmt.getArgument(), stmt);
    }

    @Override
    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, value);
    }

    private static class SchemaTreeEquality<D extends DeclaredStatement<QName>>
    implements StatementSupport.StatementEquality<QName, D> {
        private SchemaTreeEquality() {
        }

        @Override
        public boolean canReuseCurrent(EffectiveStmtCtx.Current<QName, D> copy, EffectiveStmtCtx.Current<QName, D> current, Collection<? extends EffectiveStatement<?, ?>> substatements) {
            return SchemaTreeEquality.equalHistory(copy.history(), current.history()) && ((QName)copy.getArgument()).equals(current.getArgument());
        }

        private static boolean equalHistory(CopyHistory copy, CopyHistory current) {
            return copy.isAugmenting() == current.isAugmenting() && copy.isAddedByUses() == current.isAddedByUses();
        }

        private static final class Instantiated<D extends DeclaredStatement<QName>>
        extends SchemaTreeEquality<D> {
            private Instantiated() {
            }

            @Override
            public boolean canReuseCurrent(EffectiveStmtCtx.Current<QName, D> copy, EffectiveStmtCtx.Current<QName, D> current, Collection<? extends EffectiveStatement<?, ?>> substatements) {
                return copy.effectiveConfig() == current.effectiveConfig() && super.canReuseCurrent(copy, current, substatements);
            }
        }
    }
}

