/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public abstract class StatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
implements StatementDefinition,
StatementFactory<A, D, E> {
    private final @NonNull StatementPolicy<A, D> policy;
    private final @NonNull StatementDefinition def;
    private final @NonNull CopyPolicy copyPolicy;

    @Beta
    protected StatementSupport(StatementSupport<A, D, E> delegate) {
        Preconditions.checkArgument((delegate != this ? 1 : 0) != 0);
        this.def = delegate.def;
        this.policy = delegate.policy;
        this.copyPolicy = delegate.copyPolicy;
    }

    @Beta
    protected StatementSupport(StatementDefinition publicDefinition, StatementPolicy<A, D> policy) {
        Preconditions.checkArgument((publicDefinition != this ? 1 : 0) != 0);
        this.def = Objects.requireNonNull(publicDefinition);
        this.policy = Objects.requireNonNull(policy);
        this.copyPolicy = policy.copyPolicy;
    }

    public final @NonNull StatementDefinition getPublicView() {
        return this.def;
    }

    public final @NonNull CopyPolicy copyPolicy() {
        return this.copyPolicy;
    }

    @Override
    public final boolean canReuseCurrent(EffectiveStmtCtx.Current<A, D> copy, EffectiveStmtCtx.Current<A, D> current, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return this.policy.canReuseCurrent(copy, current, substatements);
    }

    @Override
    public EffectiveStatementState extractEffectiveState(E stmt) {
        return null;
    }

    public abstract A parseArgumentValue(StmtContext<?, ?, ?> var1, String var2);

    public A adaptArgumentValue(@NonNull StmtContext<A, D, E> ctx, @NonNull QNameModule targetModule) {
        return ctx.argument();
    }

    public void onStatementAdded(@NonNull StmtContext.Mutable<A, D, E> stmt) {
    }

    public void onPreLinkageDeclared(@NonNull StmtContext.Mutable<A, D, E> stmt) {
    }

    public void onLinkageDeclared(@NonNull StmtContext.Mutable<A, D, E> stmt) {
    }

    public void onStatementDefinitionDeclared(StmtContext.Mutable<A, D, E> stmt) {
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<A, D, E> stmt) {
        SubstatementValidator validator = this.substatementValidator();
        if (validator != null) {
            validator.validate(stmt);
        }
    }

    protected abstract @Nullable SubstatementValidator substatementValidator();

    public boolean hasArgumentSpecificSupports() {
        return false;
    }

    public @Nullable StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        return null;
    }

    public String internArgument(String rawArgument) {
        return rawArgument;
    }

    @Beta
    public boolean isIgnoringIfFeatures() {
        return false;
    }

    @Beta
    public boolean isIgnoringConfig() {
        return false;
    }

    public final QName getStatementName() {
        return this.def.getStatementName();
    }

    public final Optional<ArgumentDefinition> getArgumentDefinition() {
        return this.def.getArgumentDefinition();
    }

    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.def.getDeclaredRepresentationClass();
    }

    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.def.getEffectiveRepresentationClass();
    }

    public static enum CopyPolicy {
        CONTEXT_INDEPENDENT,
        EXACT_REPLICA,
        DECLARED_COPY,
        REJECT,
        IGNORE;

    }

    @FunctionalInterface
    public static interface StatementEquality<A, D extends DeclaredStatement<A>> {
        public boolean canReuseCurrent(@NonNull EffectiveStmtCtx.Current<A, D> var1, @NonNull EffectiveStmtCtx.Current<A, D> var2, @NonNull Collection<? extends EffectiveStatement<?, ?>> var3);
    }

    public static abstract class StatementPolicy<A, D extends DeclaredStatement<A>>
    implements Immutable {
        final @NonNull CopyPolicy copyPolicy;

        StatementPolicy(CopyPolicy copyPolicy) {
            this.copyPolicy = Objects.requireNonNull(copyPolicy);
        }

        public static final <A, D extends DeclaredStatement<A>> @NonNull StatementPolicy<A, D> contextIndependent() {
            return EqualSemantics.CONTEXT_INDEPENDENT;
        }

        public static final <A, D extends DeclaredStatement<A>> @NonNull StatementPolicy<A, D> exactReplica() {
            return EqualSemantics.EXACT_REPLICA;
        }

        public static final <A, D extends DeclaredStatement<A>> @NonNull StatementPolicy<A, D> ignore() {
            return AlwaysFail.IGNORE;
        }

        public static final <A, D extends DeclaredStatement<A>> @NonNull StatementPolicy<A, D> reject() {
            return AlwaysFail.REJECT;
        }

        public static final <A, D extends DeclaredStatement<A>> @NonNull StatementPolicy<A, D> copyDeclared(@NonNull StatementEquality<A, D> equality) {
            return new EqualSemantics<A, D>(equality);
        }

        public static final <A, D extends DeclaredStatement<A>> @NonNull StatementPolicy<A, D> alwaysCopyDeclared() {
            return EqualSemantics.ALWAYS_COPY;
        }

        abstract boolean canReuseCurrent(@NonNull EffectiveStmtCtx.Current<A, D> var1, @NonNull EffectiveStmtCtx.Current<A, D> var2, @NonNull Collection<? extends EffectiveStatement<?, ?>> var3);

        private static final class EqualSemantics<A, D extends DeclaredStatement<A>>
        extends StatementPolicy<A, D> {
            static final @NonNull EqualSemantics<?, ?> ALWAYS_COPY = new EqualSemantics((copy, stmt, substatements) -> false);
            static final @NonNull EqualSemantics<?, ?> CONTEXT_INDEPENDENT = new EqualSemantics(CopyPolicy.CONTEXT_INDEPENDENT, (copy, stmt, substatements) -> true);
            static final @NonNull EqualSemantics<?, ?> EXACT_REPLICA = new EqualSemantics(CopyPolicy.EXACT_REPLICA, (copy, stmt, substatements) -> true);
            private final @NonNull StatementEquality<A, D> equality;

            private EqualSemantics(CopyPolicy copyPolicy, StatementEquality<A, D> equality) {
                super(copyPolicy);
                this.equality = Objects.requireNonNull(equality);
            }

            EqualSemantics(StatementEquality<A, D> equality) {
                this(CopyPolicy.DECLARED_COPY, equality);
            }

            @Override
            boolean canReuseCurrent(EffectiveStmtCtx.Current<A, D> copy, EffectiveStmtCtx.Current<A, D> current, Collection<? extends EffectiveStatement<?, ?>> substatements) {
                return this.equality.canReuseCurrent(copy, current, substatements);
            }
        }

        private static final class AlwaysFail<A, D extends DeclaredStatement<A>>
        extends StatementPolicy<A, D> {
            static final @NonNull AlwaysFail<?, ?> IGNORE = new AlwaysFail(CopyPolicy.IGNORE);
            static final @NonNull AlwaysFail<?, ?> REJECT = new AlwaysFail(CopyPolicy.REJECT);

            private AlwaysFail(CopyPolicy copyPolicy) {
                super(copyPolicy);
            }

            @Override
            boolean canReuseCurrent(EffectiveStmtCtx.Current<A, D> copy, EffectiveStmtCtx.Current<A, D> current, Collection<? extends EffectiveStatement<?, ?>> substatements) {
                throw new VerifyException("This implementation should never be invoked");
            }
        }
    }
}

