/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationInFile;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationInText;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.StatementOrigin;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class ExplicitStatement
extends StatementSourceReference
implements DeclarationReference {
    private final String file;
    private final int line;
    private final int column;

    ExplicitStatement(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public static @NonNull ExplicitStatement atPosition(int line, int column) {
        return new InText(null, line, column);
    }

    public static @NonNull ExplicitStatement atPosition(@Nullable String fileName, int line, int column) {
        return fileName == null ? ExplicitStatement.atPosition(line, column) : new InTextFile(fileName, line, column);
    }

    public static @NonNull ExplicitStatement inFile(@NonNull String fileName) {
        return new InFile(fileName);
    }

    @Override
    public final StatementOrigin statementOrigin() {
        return StatementOrigin.DECLARATION;
    }

    @Override
    public final DeclarationReference declarationReference() {
        return this;
    }

    public final String toHumanReadable() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.file != null ? this.file : "<UNKNOWN>");
        if (this.line > 0) {
            sb.append(':').append(this.line);
        }
        if (this.column > 0) {
            sb.append(':').append(this.column);
        }
        return sb.toString();
    }

    public final int hashCode() {
        return Objects.hash(this.file(), this.line(), this.column());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ExplicitStatement other = (ExplicitStatement)obj;
        return this.line == other.line && this.column == other.column && Objects.equals(this.file, other.file);
    }

    @Override
    public final String toString() {
        return this.toHumanReadable();
    }

    final String file() {
        return this.file;
    }

    final int line() {
        return this.line;
    }

    final int column() {
        return this.column;
    }

    private static final class InTextFile
    extends InText
    implements DeclarationInFile {
        InTextFile(String fileName, int line, int column) {
            super(fileName, line, column);
            Preconditions.checkArgument((!fileName.isEmpty() ? 1 : 0) != 0, (Object)"Invalid empty file name");
        }

        public String fileName() {
            return (String)Verify.verifyNotNull((Object)this.file());
        }
    }

    private static class InText
    extends ExplicitStatement
    implements DeclarationInText {
        InText(String file, int line, int column) {
            super(file, line, column);
            Preconditions.checkArgument((line > 0 ? 1 : 0) != 0, (String)"Invalid start line %s", (int)line);
            Preconditions.checkArgument((column > 0 ? 1 : 0) != 0, (String)"Invalid start column %s", (int)column);
        }

        public int startLine() {
            return this.line();
        }

        public int startColumn() {
            return this.column();
        }
    }

    private static final class InFile
    extends ExplicitStatement
    implements DeclarationInFile {
        InFile(String fileName) {
            super(fileName, -1, -1);
            Preconditions.checkArgument((!fileName.isEmpty() ? 1 : 0) != 0, (Object)"Invalid empty file name");
        }

        public String fileName() {
            return (String)Verify.verifyNotNull((Object)this.file());
        }
    }
}

