/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;

public class PrefixToModuleMap
implements PrefixToModule {
    private final Map<String, QNameModule> prefixToModuleMap = new HashMap<String, QNameModule>();
    private final Map<XMLNamespace, QNameModule> namespaceToModuleMap = new HashMap<XMLNamespace, QNameModule>();

    public void put(String prefix, QNameModule module) {
        this.prefixToModuleMap.put(prefix, module);
        this.namespaceToModuleMap.put(module.getNamespace(), module);
    }

    @Override
    public QNameModule get(String prefix) {
        return this.prefixToModuleMap.get(prefix);
    }

    @Override
    public QNameModule getByNamespace(String namespace) {
        return this.namespaceToModuleMap.get(XMLNamespace.of((String)namespace));
    }
}

