/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;

@Beta
@NonNullByDefault
public abstract class YangSourceDefinition {
    private final ModuleEffectiveStatement module;

    private YangSourceDefinition(ModuleEffectiveStatement module) {
        this.module = Objects.requireNonNull(module);
    }

    public static Optional<YangSourceDefinition> of(Module module) {
        ModuleEffectiveStatement effective = (ModuleEffectiveStatement)module.asEffectiveStatement();
        ModuleStatement declared = (ModuleStatement)effective.getDeclared();
        if (declared != null) {
            return Optional.of(new Single(effective, (DocumentedNode)module));
        }
        return Optional.empty();
    }

    public static Optional<YangSourceDefinition> of(Module module, SchemaNode node) {
        return YangSourceDefinition.of((ModuleEffectiveStatement)module.asEffectiveStatement(), node);
    }

    public static Optional<YangSourceDefinition> of(ModuleEffectiveStatement module, SchemaNode node) {
        DeclaredStatement declared;
        if (node instanceof EffectiveStatement && (declared = ((EffectiveStatement)node).getDeclared()) != null) {
            return Optional.of(new Single(module, (DocumentedNode)node));
        }
        return Optional.empty();
    }

    public static Optional<YangSourceDefinition> of(Module module, Collection<? extends SchemaNode> nodes) {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
        boolean anyDeclared = nodes.stream().anyMatch(node -> node instanceof EffectiveStatement && ((EffectiveStatement)node).getDeclared() != null);
        if (anyDeclared) {
            return Optional.of(new Multiple((ModuleEffectiveStatement)module.asEffectiveStatement(), nodes));
        }
        return Optional.empty();
    }

    public final ModuleEffectiveStatement getModule() {
        return this.module;
    }

    public static final class Single
    extends YangSourceDefinition {
        private final DocumentedNode node;

        Single(ModuleEffectiveStatement module, DocumentedNode node) {
            super(module);
            this.node = Objects.requireNonNull(node);
        }

        public DocumentedNode getNode() {
            return this.node;
        }
    }

    public static final class Multiple
    extends YangSourceDefinition {
        private final List<? extends SchemaNode> nodes;

        Multiple(ModuleEffectiveStatement module, Collection<? extends SchemaNode> nodes) {
            super(module);
            this.nodes = ImmutableList.copyOf(nodes);
        }

        public List<? extends SchemaNode> getNodes() {
            return this.nodes.stream().filter(node -> node instanceof EffectiveStatement && ((EffectiveStatement)node).getDeclared() != null).collect(Collectors.toList());
        }
    }
}

