/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.codec.EnumCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

@Beta
public final class EnumStringCodec
extends TypeDefinitionAwareCodec<String, EnumTypeDefinition>
implements EnumCodec<String> {
    private final ImmutableMap<String, String> values;

    private EnumStringCodec(@NonNull EnumTypeDefinition typeDef) {
        super(typeDef, String.class);
        this.values = (ImmutableMap)typeDef.getValues().stream().map(pair -> pair.getName().intern()).collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), (Function)Functions.identity()));
    }

    public static EnumStringCodec from(EnumTypeDefinition normalizedType) {
        return new EnumStringCodec(Objects.requireNonNull(normalizedType));
    }

    protected String deserializeImpl(String product) {
        String result = (String)this.values.get((Object)product);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Invalid value '%s' for enum type. Allowed values are: %s", (Object)product, (Object)this.values.keySet());
        return result;
    }

    protected String serializeImpl(String input) {
        return input;
    }
}

