/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedValueNode;
import org.opendaylight.yangtools.yang.data.spi.node.AbstractNormalizedNode;

public class ImmutableUnkeyedListNodeBuilder
implements CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> {
    private List<UnkeyedListEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    protected ImmutableUnkeyedListNodeBuilder() {
        this.value = new LinkedList<UnkeyedListEntryNode>();
        this.dirty = false;
    }

    protected ImmutableUnkeyedListNodeBuilder(ImmutableUnkeyedListNode node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = new LinkedList<UnkeyedListEntryNode>();
        Iterables.addAll(this.value, (Iterable)((Iterable)node.body()));
        this.dirty = true;
    }

    public static CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> create() {
        return new ImmutableUnkeyedListNodeBuilder();
    }

    public static CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> create(int sizeHint) {
        return new ImmutableUnkeyedListNodeBuilder();
    }

    public static CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> create(UnkeyedListNode node) {
        if (!(node instanceof ImmutableUnkeyedListNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableUnkeyedListNodeBuilder((ImmutableUnkeyedListNode)node);
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedList<UnkeyedListEntryNode>(this.value);
            this.dirty = false;
        }
    }

    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withChild(UnkeyedListEntryNode child) {
        this.checkDirty();
        this.value.add(child);
        return this;
    }

    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        throw new UnsupportedOperationException("Children does not have identifiers.");
    }

    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withValue(Collection<UnkeyedListEntryNode> withValue) {
        for (UnkeyedListEntryNode node : withValue) {
            this.withChild(node);
        }
        return this;
    }

    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public UnkeyedListNode build() {
        this.dirty = true;
        if (this.value.isEmpty()) {
            return new EmptyImmutableUnkeyedListNode(this.nodeIdentifier);
        }
        return new ImmutableUnkeyedListNode(this.nodeIdentifier, (ImmutableList<UnkeyedListEntryNode>)ImmutableList.copyOf(this.value));
    }

    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> addChild(UnkeyedListEntryNode child) {
        return this.withChild(child);
    }

    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, UnkeyedListEntryNode, UnkeyedListNode> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableUnkeyedListNode
    extends AbstractImmutableNormalizedValueNode<YangInstanceIdentifier.NodeIdentifier, UnkeyedListNode, Collection<UnkeyedListEntryNode>>
    implements UnkeyedListNode {
        private final ImmutableList<UnkeyedListEntryNode> children;

        ImmutableUnkeyedListNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, ImmutableList<UnkeyedListEntryNode> children) {
            super(nodeIdentifier, children);
            this.children = children;
        }

        public UnkeyedListEntryNode childAt(int position) {
            return (UnkeyedListEntryNode)this.children.get(position);
        }

        public int size() {
            return this.children.size();
        }

        protected Class<UnkeyedListNode> implementedType() {
            return UnkeyedListNode.class;
        }

        protected int valueHashCode() {
            return this.children.hashCode();
        }

        protected boolean valueEquals(UnkeyedListNode other) {
            ImmutableList<UnkeyedListEntryNode> otherChildren = other instanceof ImmutableUnkeyedListNode ? ((ImmutableUnkeyedListNode)other).children : other.body();
            return otherChildren instanceof List ? this.children.equals(otherChildren) : Iterables.elementsEqual(this.children, otherChildren);
        }
    }

    protected static final class EmptyImmutableUnkeyedListNode
    extends AbstractNormalizedNode<YangInstanceIdentifier.NodeIdentifier, UnkeyedListNode>
    implements UnkeyedListNode {
        protected EmptyImmutableUnkeyedListNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier) {
            super((YangInstanceIdentifier.PathArgument)nodeIdentifier);
        }

        public ImmutableList<UnkeyedListEntryNode> body() {
            return ImmutableList.of();
        }

        public UnkeyedListEntryNode childAt(int position) {
            throw new IndexOutOfBoundsException();
        }

        public int size() {
            return 0;
        }

        protected Class<UnkeyedListNode> implementedType() {
            return UnkeyedListNode.class;
        }

        protected int valueHashCode() {
            return 1;
        }

        protected boolean valueEquals(UnkeyedListNode other) {
            return other.isEmpty();
        }
    }
}

