/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataNodeContainerValidator;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.data.util.NormalizedNodeSchemaUtils;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;

final class SchemaAwareImmutableChoiceNodeBuilder
extends ImmutableChoiceNodeBuilder {
    private final ChoiceSchemaNode schema;
    private DataNodeContainerValidator validator;

    SchemaAwareImmutableChoiceNodeBuilder(ChoiceSchemaNode schema) {
        this.schema = Objects.requireNonNull(schema, "Schema was null");
        super.withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> withChild(DataContainerChild child) {
        if (this.validator == null) {
            Optional detectedCaseOpt = NormalizedNodeSchemaUtils.detectCase((ChoiceSchemaNode)this.schema, (DataContainerChild)child);
            DataValidationException.checkLegalChild(detectedCaseOpt.isPresent(), child.getIdentifier(), this.schema);
            this.validator = new DataNodeContainerValidator((DataNodeContainer)detectedCaseOpt.get());
        }
        return super.withChild(this.validator.validateChild(child));
    }

    @Override
    public ChoiceNode build() {
        return super.build();
    }
}

