/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.japi.Procedure;
import java.util.Objects;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.DelegatingPersistentDataProvider;
import org.opendaylight.controller.cluster.PersistentDataProvider;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.messages.PersistentPayload;

class RaftActorDelegatingPersistentDataProvider
extends DelegatingPersistentDataProvider {
    private final PersistentDataProvider persistentProvider;

    RaftActorDelegatingPersistentDataProvider(DataPersistenceProvider delegate, PersistentDataProvider persistentProvider) {
        super(delegate);
        this.persistentProvider = Objects.requireNonNull(persistentProvider);
    }

    public <T> void persist(T entry, Procedure<T> procedure) {
        this.doPersist(entry, procedure, false);
    }

    public <T> void persistAsync(T entry, Procedure<T> procedure) {
        this.doPersist(entry, procedure, true);
    }

    private <T> void doPersist(T entry, Procedure<T> procedure, boolean async) {
        if (this.getDelegate().isRecoveryApplicable()) {
            this.persistSuper(entry, procedure, async);
        } else if (entry instanceof ReplicatedLogEntry) {
            Payload payload = ((ReplicatedLogEntry)entry).getData();
            if (payload instanceof PersistentPayload) {
                if (async) {
                    this.persistentProvider.persistAsync((Object)payload, p -> procedure.apply(entry));
                } else {
                    this.persistentProvider.persist((Object)payload, p -> procedure.apply(entry));
                }
            } else {
                this.persistSuper(entry, procedure, async);
            }
        } else {
            this.persistSuper(entry, procedure, async);
        }
    }

    private <T> void persistSuper(T object, Procedure<T> procedure, boolean async) {
        if (async) {
            super.persistAsync(object, procedure);
        } else {
            super.persist(object, procedure);
        }
    }
}

