/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Cancellable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;
import org.opendaylight.controller.cluster.io.SharedFileBackedOutputStream;
import org.opendaylight.controller.cluster.messaging.MessageSlicer;
import org.opendaylight.controller.cluster.messaging.SliceOptions;
import org.opendaylight.controller.cluster.raft.ClientRequestTracker;
import org.opendaylight.controller.cluster.raft.ClientRequestTrackerImpl;
import org.opendaylight.controller.cluster.raft.FollowerLogInformation;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.VotingState;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.base.messages.CheckConsensusReached;
import org.opendaylight.controller.cluster.raft.base.messages.Replicate;
import org.opendaylight.controller.cluster.raft.base.messages.SendHeartBeat;
import org.opendaylight.controller.cluster.raft.base.messages.SendInstallSnapshot;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractRaftActorBehavior;
import org.opendaylight.controller.cluster.raft.behaviors.FollowerIdentifier;
import org.opendaylight.controller.cluster.raft.behaviors.LeaderInstallSnapshotState;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.IdentifiablePayload;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshot;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshotReply;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.messages.RaftRPC;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.RequestVoteReply;
import org.opendaylight.controller.cluster.raft.messages.UnInitializedFollowerSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.yangtools.concepts.Identifier;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractLeader
extends AbstractRaftActorBehavior {
    private final Map<String, FollowerLogInformation> followerToLog = new HashMap<String, FollowerLogInformation>();
    private final Queue<ClientRequestTracker> trackers = new LinkedList<ClientRequestTracker>();
    private final Map<Long, SharedFileBackedOutputStream> sharedSerializedAppendEntriesStreams = new HashMap<Long, SharedFileBackedOutputStream>();
    private final MessageSlicer appendEntriesMessageSlicer;
    private Cancellable heartbeatSchedule = null;
    private Optional<SnapshotHolder> snapshotHolder = Optional.empty();
    private int minReplicationCount;

    protected AbstractLeader(RaftActorContext context, RaftState state, @Nullable AbstractLeader initializeFromLeader) {
        super(context, state);
        this.appendEntriesMessageSlicer = MessageSlicer.builder().logContext(this.logName()).messageSliceSize(context.getConfigParams().getSnapshotChunkSize()).expireStateAfterInactivity(context.getConfigParams().getElectionTimeOutInterval().toMillis() * 3L, TimeUnit.MILLISECONDS).build();
        if (initializeFromLeader != null) {
            this.followerToLog.putAll(initializeFromLeader.followerToLog);
            this.snapshotHolder = initializeFromLeader.snapshotHolder;
            this.trackers.addAll(initializeFromLeader.trackers);
        } else {
            for (PeerInfo peerInfo : context.getPeers()) {
                FollowerLogInformation followerLogInformation = new FollowerLogInformation(peerInfo, context);
                this.followerToLog.put(peerInfo.getId(), followerLogInformation);
            }
        }
        this.log.debug("{}: Election: Leader has following peers: {}", (Object)this.logName(), this.getFollowerIds());
        this.updateMinReplicaCount();
        this.sendAppendEntries(0L, false);
        this.scheduleHeartBeat(context.getConfigParams().getHeartBeatInterval());
    }

    protected AbstractLeader(RaftActorContext context, RaftState state) {
        this(context, state, null);
    }

    public final Collection<String> getFollowerIds() {
        return this.followerToLog.keySet();
    }

    public void addFollower(String followerId) {
        FollowerLogInformation followerLogInformation = new FollowerLogInformation(this.context.getPeerInfo(followerId), this.context);
        this.followerToLog.put(followerId, followerLogInformation);
        if (this.heartbeatSchedule == null) {
            this.scheduleHeartBeat(this.context.getConfigParams().getHeartBeatInterval());
        }
    }

    public void removeFollower(String followerId) {
        this.followerToLog.remove(followerId);
    }

    public final void updateMinReplicaCount() {
        int numVoting = 0;
        for (PeerInfo peer : this.context.getPeers()) {
            if (!peer.isVoting()) continue;
            ++numVoting;
        }
        this.minReplicationCount = this.getMajorityVoteCount(numVoting);
    }

    protected int getMinIsolatedLeaderPeerCount() {
        return this.minReplicationCount > 0 ? this.minReplicationCount - 1 : 0;
    }

    @VisibleForTesting
    void setSnapshotHolder(@Nullable SnapshotHolder snapshotHolder) {
        this.snapshotHolder = Optional.ofNullable(snapshotHolder);
    }

    @VisibleForTesting
    boolean hasSnapshot() {
        return this.snapshotHolder.isPresent();
    }

    @Override
    protected RaftActorBehavior handleAppendEntries(ActorRef sender, AppendEntries appendEntries) {
        this.log.debug("{}: handleAppendEntries: {}", (Object)this.logName(), (Object)appendEntries);
        return this;
    }

    @Override
    protected RaftActorBehavior handleAppendEntriesReply(ActorRef sender, AppendEntriesReply appendEntriesReply) {
        this.log.trace("{}: handleAppendEntriesReply: {}", (Object)this.logName(), (Object)appendEntriesReply);
        String followerId = appendEntriesReply.getFollowerId();
        FollowerLogInformation followerLogInformation = this.followerToLog.get(followerId);
        if (followerLogInformation == null) {
            this.log.error("{}: handleAppendEntriesReply - unknown follower {}", (Object)this.logName(), (Object)followerId);
            return this;
        }
        long lastActivityNanos = followerLogInformation.nanosSinceLastActivity();
        if (lastActivityNanos > this.context.getConfigParams().getElectionTimeOutInterval().toNanos()) {
            this.log.warn("{} : handleAppendEntriesReply delayed beyond election timeout, appendEntriesReply : {}, timeSinceLastActivity : {}, lastApplied : {}, commitIndex : {}", new Object[]{this.logName(), appendEntriesReply, TimeUnit.NANOSECONDS.toMillis(lastActivityNanos), this.context.getLastApplied(), this.context.getCommitIndex()});
        }
        followerLogInformation.markFollowerActive();
        followerLogInformation.setPayloadVersion(appendEntriesReply.getPayloadVersion());
        followerLogInformation.setRaftVersion(appendEntriesReply.getRaftVersion());
        followerLogInformation.setNeedsLeaderAddress(appendEntriesReply.isNeedsLeaderAddress());
        long followerLastLogIndex = appendEntriesReply.getLogLastIndex();
        boolean updated = false;
        if (appendEntriesReply.getLogLastIndex() > this.context.getReplicatedLog().lastIndex()) {
            this.log.info("{}: handleAppendEntriesReply: follower {} lastIndex {} is ahead of our lastIndex {} (snapshotIndex {}, snapshotTerm {}) - forcing install snaphot", new Object[]{this.logName(), followerLogInformation.getId(), appendEntriesReply.getLogLastIndex(), this.context.getReplicatedLog().lastIndex(), this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().getSnapshotTerm()});
            followerLogInformation.setMatchIndex(-1L);
            followerLogInformation.setNextIndex(-1L);
            this.initiateCaptureSnapshot(followerId);
            updated = true;
        } else if (appendEntriesReply.isSuccess()) {
            long followersLastLogTermInLeadersLog = this.getLogEntryTerm(followerLastLogIndex);
            if (followerLastLogIndex >= 0L && followersLastLogTermInLeadersLog >= 0L && followersLastLogTermInLeadersLog != appendEntriesReply.getLogLastTerm()) {
                followerLogInformation.setNextIndex(followerLastLogIndex - 1L);
                updated = true;
                this.log.info("{}: handleAppendEntriesReply: follower {} last log term {} for index {} conflicts with the leader's {} - set the follower's next index to {}", new Object[]{this.logName(), followerId, appendEntriesReply.getLogLastTerm(), appendEntriesReply.getLogLastIndex(), followersLastLogTermInLeadersLog, followerLogInformation.getNextIndex()});
            } else {
                updated = this.updateFollowerLogInformation(followerLogInformation, appendEntriesReply);
            }
        } else {
            this.log.info("{}: handleAppendEntriesReply - received unsuccessful reply: {}, leader snapshotIndex: {}, snapshotTerm: {}, replicatedToAllIndex: {}", new Object[]{this.logName(), appendEntriesReply, this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().getSnapshotTerm(), this.getReplicatedToAllIndex()});
            long followersLastLogTermInLeadersLogOrSnapshot = this.getLogEntryOrSnapshotTerm(followerLastLogIndex);
            if (appendEntriesReply.isForceInstallSnapshot()) {
                followerLogInformation.setMatchIndex(-1L);
                followerLogInformation.setNextIndex(-1L);
                this.initiateCaptureSnapshot(followerId);
            } else if (followerLastLogIndex < 0L || followersLastLogTermInLeadersLogOrSnapshot >= 0L && followersLastLogTermInLeadersLogOrSnapshot == appendEntriesReply.getLogLastTerm()) {
                updated = this.updateFollowerLogInformation(followerLogInformation, appendEntriesReply);
                this.log.info("{}: follower {} appears to be behind the leader from the last snapshot - updated: matchIndex: {}, nextIndex: {}", new Object[]{this.logName(), followerId, followerLogInformation.getMatchIndex(), followerLogInformation.getNextIndex()});
            } else if (followerLogInformation.decrNextIndex(appendEntriesReply.getLogLastIndex())) {
                updated = true;
                this.log.info("{}: follower {} last log term {} conflicts with the leader's {} - dec next index to {}", new Object[]{this.logName(), followerId, appendEntriesReply.getLogLastTerm(), followersLastLogTermInLeadersLogOrSnapshot, followerLogInformation.getNextIndex()});
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("{}: handleAppendEntriesReply from {}: commitIndex: {}, lastAppliedIndex: {}, currentTerm: {}", new Object[]{this.logName(), followerId, this.context.getCommitIndex(), this.context.getLastApplied(), this.currentTerm()});
        }
        this.possiblyUpdateCommitIndex();
        this.sendUpdatesToFollower(followerId, followerLogInformation, false, !updated);
        return this;
    }

    private void possiblyUpdateCommitIndex() {
        long index = this.context.getCommitIndex() + 1L;
        while (true) {
            int replicatedCount;
            ReplicatedLogEntry replicatedLogEntry;
            if ((replicatedLogEntry = this.context.getReplicatedLog().get(index)) == null) {
                this.log.trace("{}: ReplicatedLogEntry not found for index {} - snapshotIndex: {}, journal size: {}", new Object[]{this.logName(), index, this.context.getReplicatedLog().getSnapshotIndex(), this.context.getReplicatedLog().size()});
                break;
            }
            int n = replicatedCount = replicatedLogEntry.isPersistencePending() ? 0 : 1;
            if (replicatedCount == 0) break;
            this.log.trace("{}: checking Nth index {}", (Object)this.logName(), (Object)index);
            for (FollowerLogInformation info : this.followerToLog.values()) {
                PeerInfo peerInfo = this.context.getPeerInfo(info.getId());
                if (info.getMatchIndex() >= index && peerInfo != null && peerInfo.isVoting()) {
                    ++replicatedCount;
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("{}: Not counting follower {} - matchIndex: {}, {}", new Object[]{this.logName(), info.getId(), info.getMatchIndex(), peerInfo});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("{}: replicatedCount {}, minReplicationCount: {}", new Object[]{this.logName(), replicatedCount, this.minReplicationCount});
            }
            if (replicatedCount >= this.minReplicationCount) {
                if (replicatedLogEntry.getTerm() == this.currentTerm()) {
                    this.log.trace("{}: Setting commit index to {}", (Object)this.logName(), (Object)index);
                    this.context.setCommitIndex(index);
                } else {
                    this.log.debug("{}: Not updating commit index to {} - retrieved log entry with index {}, term {} does not match the current term {}", new Object[]{this.logName(), index, replicatedLogEntry.getIndex(), replicatedLogEntry.getTerm(), this.currentTerm()});
                }
            } else {
                this.log.trace("{}: minReplicationCount not reached, actual {} - breaking", (Object)this.logName(), (Object)replicatedCount);
                break;
            }
            ++index;
        }
        if (this.context.getCommitIndex() > this.context.getLastApplied()) {
            this.log.debug("{}: Applying to log - commitIndex: {}, lastAppliedIndex: {}", new Object[]{this.logName(), this.context.getCommitIndex(), this.context.getLastApplied()});
            this.applyLogToStateMachine(this.context.getCommitIndex());
        }
        if (!this.context.getSnapshotManager().isCapturing()) {
            this.purgeInMemoryLog();
        }
    }

    private boolean updateFollowerLogInformation(FollowerLogInformation followerLogInformation, AppendEntriesReply appendEntriesReply) {
        boolean updated = followerLogInformation.setMatchIndex(appendEntriesReply.getLogLastIndex());
        boolean bl = updated = followerLogInformation.setNextIndex(appendEntriesReply.getLogLastIndex() + 1L) || updated;
        if (updated && this.log.isDebugEnabled()) {
            this.log.debug("{}: handleAppendEntriesReply - FollowerLogInformation for {} updated: matchIndex: {}, nextIndex: {}", new Object[]{this.logName(), followerLogInformation.getId(), followerLogInformation.getMatchIndex(), followerLogInformation.getNextIndex()});
        }
        return updated;
    }

    private void purgeInMemoryLog() {
        long minReplicatedToAllIndex = this.followerToLog.isEmpty() ? this.context.getLastApplied() : Long.MAX_VALUE;
        for (FollowerLogInformation info : this.followerToLog.values()) {
            minReplicatedToAllIndex = Math.min(minReplicatedToAllIndex, info.getMatchIndex());
        }
        super.performSnapshotWithoutCapture(minReplicatedToAllIndex);
    }

    private ClientRequestTracker removeClientRequestTracker(long logIndex) {
        Iterator it = this.trackers.iterator();
        while (it.hasNext()) {
            ClientRequestTracker t = (ClientRequestTracker)it.next();
            if (t.getIndex() != logIndex) continue;
            it.remove();
            return t;
        }
        return null;
    }

    @Override
    final ApplyState getApplyStateFor(ReplicatedLogEntry entry) {
        ClientRequestTracker tracker = this.removeClientRequestTracker(entry.getIndex());
        if (tracker != null) {
            return new ApplyState(tracker.getClientActor(), tracker.getIdentifier(), entry);
        }
        Payload payload = entry.getData();
        if (payload instanceof IdentifiablePayload) {
            return new ApplyState(null, (Identifier)((IdentifiablePayload)payload).getIdentifier(), entry);
        }
        return new ApplyState(null, null, entry);
    }

    @Override
    protected RaftActorBehavior handleRequestVoteReply(ActorRef sender, RequestVoteReply requestVoteReply) {
        return this;
    }

    protected void beforeSendHeartbeat() {
    }

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object message) {
        RaftRPC rpc;
        Objects.requireNonNull(sender, "sender should not be null");
        if (this.appendEntriesMessageSlicer.handleMessage(message)) {
            return this;
        }
        if (message instanceof RaftRPC && (rpc = (RaftRPC)message).getTerm() > this.context.getTermInformation().getCurrentTerm() && this.shouldUpdateTerm(rpc)) {
            this.log.info("{}: Term {} in \"{}\" message is greater than leader's term {} - switching to Follower", new Object[]{this.logName(), rpc.getTerm(), rpc, this.context.getTermInformation().getCurrentTerm()});
            this.context.getTermInformation().updateAndPersist(rpc.getTerm(), null);
            if (rpc instanceof RequestVote && this.context.getRaftActorLeadershipTransferCohort() != null) {
                this.log.debug("{}: Leadership transfer in progress - processing RequestVote", (Object)this.logName());
                super.handleMessage(sender, rpc);
            }
            return this.internalSwitchBehavior(RaftState.Follower);
        }
        if (message instanceof SendHeartBeat) {
            this.beforeSendHeartbeat();
            this.sendHeartBeat();
            this.scheduleHeartBeat(this.context.getConfigParams().getHeartBeatInterval());
        } else if (message instanceof SendInstallSnapshot) {
            SendInstallSnapshot sendInstallSnapshot = (SendInstallSnapshot)message;
            this.setSnapshotHolder(new SnapshotHolder(sendInstallSnapshot.getSnapshot(), sendInstallSnapshot.getSnapshotBytes()));
            this.sendInstallSnapshot();
        } else if (message instanceof Replicate) {
            this.replicate((Replicate)message);
        } else if (message instanceof InstallSnapshotReply) {
            this.handleInstallSnapshotReply((InstallSnapshotReply)message);
        } else if (message instanceof CheckConsensusReached) {
            this.possiblyUpdateCommitIndex();
        } else {
            return super.handleMessage(sender, message);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS"}, justification="JDT nullness with SpotBugs at setSnapshotHolder(null)")
    private void handleInstallSnapshotReply(InstallSnapshotReply reply) {
        this.log.debug("{}: handleInstallSnapshotReply: {}", (Object)this.logName(), (Object)reply);
        String followerId = reply.getFollowerId();
        FollowerLogInformation followerLogInformation = this.followerToLog.get(followerId);
        if (followerLogInformation == null) {
            this.log.error("{}: FollowerLogInformation not found for follower {} in InstallSnapshotReply", (Object)this.logName(), (Object)followerId);
            return;
        }
        LeaderInstallSnapshotState installSnapshotState = followerLogInformation.getInstallSnapshotState();
        if (installSnapshotState == null) {
            this.log.error("{}: LeaderInstallSnapshotState not found for follower {} in InstallSnapshotReply", (Object)this.logName(), (Object)followerId);
            return;
        }
        installSnapshotState.resetChunkTimer();
        followerLogInformation.markFollowerActive();
        if (installSnapshotState.getChunkIndex() == reply.getChunkIndex()) {
            boolean wasLastChunk = false;
            if (reply.isSuccess()) {
                if (installSnapshotState.isLastChunk(reply.getChunkIndex())) {
                    long followerMatchIndex = this.snapshotHolder.get().getLastIncludedIndex();
                    followerLogInformation.setMatchIndex(followerMatchIndex);
                    followerLogInformation.setNextIndex(followerMatchIndex + 1L);
                    followerLogInformation.clearLeaderInstallSnapshotState();
                    this.log.info("{}: Snapshot successfully installed on follower {} (last chunk {}) - matchIndex set to {}, nextIndex set to {}", new Object[]{this.logName(), followerId, reply.getChunkIndex(), followerLogInformation.getMatchIndex(), followerLogInformation.getNextIndex()});
                    if (!this.anyFollowersInstallingSnapshot()) {
                        this.setSnapshotHolder(null);
                    }
                    wasLastChunk = true;
                    if (this.context.getPeerInfo(followerId).getVotingState() == VotingState.VOTING_NOT_INITIALIZED) {
                        UnInitializedFollowerSnapshotReply unInitFollowerSnapshotSuccess = new UnInitializedFollowerSnapshotReply(followerId);
                        this.context.getActor().tell((Object)unInitFollowerSnapshotSuccess, this.context.getActor());
                        this.log.debug("Sent message UnInitializedFollowerSnapshotReply to self");
                    }
                } else {
                    installSnapshotState.markSendStatus(true);
                }
            } else {
                this.log.warn("{}: Received failed InstallSnapshotReply - will retry: {}", (Object)this.logName(), (Object)reply);
                installSnapshotState.markSendStatus(false);
            }
            if (wasLastChunk) {
                if (!this.context.getSnapshotManager().isCapturing()) {
                    this.purgeInMemoryLog();
                }
            } else {
                ActorSelection followerActor = this.context.getPeerActorSelection(followerId);
                if (followerActor != null) {
                    this.sendSnapshotChunk(followerActor, followerLogInformation);
                }
            }
        } else {
            this.log.error("{}: Chunk index {} in InstallSnapshotReply from follower {} does not match expected index {}", new Object[]{this.logName(), reply.getChunkIndex(), followerId, installSnapshotState.getChunkIndex()});
            if (reply.getChunkIndex() == -1) {
                installSnapshotState.reset();
            }
        }
    }

    private boolean anyFollowersInstallingSnapshot() {
        for (FollowerLogInformation info : this.followerToLog.values()) {
            if (info.getInstallSnapshotState() == null) continue;
            return true;
        }
        return false;
    }

    private void replicate(Replicate replicate) {
        boolean applyModificationToState;
        long logIndex = replicate.getReplicatedLogEntry().getIndex();
        this.log.debug("{}: Replicate message: identifier: {}, logIndex: {}, payload: {}, isSendImmediate: {}", new Object[]{this.logName(), replicate.getIdentifier(), logIndex, replicate.getReplicatedLogEntry().getData().getClass(), replicate.isSendImmediate()});
        if (replicate.getClientActor() != null) {
            this.trackers.add(new ClientRequestTrackerImpl(replicate.getClientActor(), replicate.getIdentifier(), logIndex));
        }
        boolean bl = applyModificationToState = !this.context.anyVotingPeers() || this.context.getRaftPolicy().applyModificationToStateBeforeConsensus();
        if (applyModificationToState) {
            this.context.setCommitIndex(logIndex);
            this.applyLogToStateMachine(logIndex);
        }
        if (replicate.isSendImmediate() && !this.followerToLog.isEmpty()) {
            this.sendAppendEntries(0L, false);
        }
    }

    protected void sendAppendEntries(long timeSinceLastActivityIntervalNanos, boolean isHeartbeat) {
        for (Map.Entry<String, FollowerLogInformation> e : this.followerToLog.entrySet()) {
            String followerId = e.getKey();
            FollowerLogInformation followerLogInformation = e.getValue();
            if (followerLogInformation.isFollowerActive() && followerLogInformation.nanosSinceLastActivity() < timeSinceLastActivityIntervalNanos) continue;
            this.sendUpdatesToFollower(followerId, followerLogInformation, true, isHeartbeat);
        }
    }

    private void sendUpdatesToFollower(String followerId, FollowerLogInformation followerLogInformation, boolean sendHeartbeat, boolean isHeartbeat) {
        ActorSelection followerActor = this.context.getPeerActorSelection(followerId);
        if (followerActor != null) {
            long followerNextIndex = followerLogInformation.getNextIndex();
            boolean isFollowerActive = followerLogInformation.isFollowerActive();
            boolean sendAppendEntries = false;
            List<ReplicatedLogEntry> entries = Collections.emptyList();
            LeaderInstallSnapshotState installSnapshotState = followerLogInformation.getInstallSnapshotState();
            if (installSnapshotState != null) {
                if (isFollowerActive) {
                    FiniteDuration snapshotReplyTimeout = this.context.getConfigParams().getHeartBeatInterval().$times(this.context.getConfigParams().getElectionTimeoutFactor() * 3L);
                    if (installSnapshotState.isChunkTimedOut(snapshotReplyTimeout)) {
                        sendAppendEntries = !this.resendSnapshotChunk(followerActor, followerLogInformation);
                    } else if (installSnapshotState.canSendNextChunk()) {
                        this.sendSnapshotChunk(followerActor, followerLogInformation);
                    }
                } else if (sendHeartbeat || followerLogInformation.hasStaleCommitIndex(this.context.getCommitIndex())) {
                    sendAppendEntries = true;
                }
            } else if (followerLogInformation.isLogEntrySlicingInProgress()) {
                sendAppendEntries = sendHeartbeat;
            } else {
                long leaderLastIndex = this.context.getReplicatedLog().lastIndex();
                long leaderSnapShotIndex = this.context.getReplicatedLog().getSnapshotIndex();
                if (!isHeartbeat && this.log.isDebugEnabled() || this.log.isTraceEnabled()) {
                    this.log.debug("{}: Checking sendAppendEntries for follower {}: active: {}, followerNextIndex: {}, leaderLastIndex: {}, leaderSnapShotIndex: {}", new Object[]{this.logName(), followerId, isFollowerActive, followerNextIndex, leaderLastIndex, leaderSnapShotIndex});
                }
                if (isFollowerActive && this.context.getReplicatedLog().isPresent(followerNextIndex)) {
                    this.log.debug("{}: sendAppendEntries: {} is present for follower {}", new Object[]{this.logName(), followerNextIndex, followerId});
                    if (followerLogInformation.okToReplicate(this.context.getCommitIndex())) {
                        entries = this.getEntriesToSend(followerLogInformation, followerActor);
                        sendAppendEntries = true;
                    }
                } else if (isFollowerActive && followerNextIndex >= 0L && leaderLastIndex > followerNextIndex && !this.context.getSnapshotManager().isCapturing()) {
                    sendAppendEntries = true;
                    if (this.canInstallSnapshot(followerNextIndex)) {
                        this.log.info("{}: Initiating install snapshot to follower {}: follower nextIndex: {}, leader snapshotIndex: {}, leader lastIndex: {}, leader log size: {}", new Object[]{this.logName(), followerId, followerNextIndex, leaderSnapShotIndex, leaderLastIndex, this.context.getReplicatedLog().size()});
                        this.initiateCaptureSnapshot(followerId);
                    } else {
                        this.log.info("{}: Follower {} is behind but cannot install snapshot: follower nextIndex: {}, leader snapshotIndex: {}, leader lastIndex: {}, leader log size: {}", new Object[]{this.logName(), followerId, followerNextIndex, leaderSnapShotIndex, leaderLastIndex, this.context.getReplicatedLog().size()});
                    }
                } else if (sendHeartbeat || followerLogInformation.hasStaleCommitIndex(this.context.getCommitIndex())) {
                    sendAppendEntries = true;
                }
            }
            if (sendAppendEntries) {
                this.sendAppendEntriesToFollower(followerActor, entries, followerLogInformation);
            }
        }
    }

    private List<ReplicatedLogEntry> getEntriesToSend(FollowerLogInformation followerLogInfo, ActorSelection followerActor) {
        int maxEntries = (int)this.context.getReplicatedLog().size();
        int maxDataSize = this.context.getConfigParams().getSnapshotChunkSize();
        long followerNextIndex = followerLogInfo.getNextIndex();
        List<ReplicatedLogEntry> entries = this.context.getReplicatedLog().getFrom(followerNextIndex, maxEntries, maxDataSize);
        if (entries.size() != 1 || entries.get(0).getData().serializedSize() <= maxDataSize) {
            return entries;
        }
        this.log.debug("{}: Log entry size {} exceeds max payload size {}", new Object[]{this.logName(), entries.get(0).getData().size(), maxDataSize});
        Long logIndex = entries.get(0).getIndex();
        SharedFileBackedOutputStream fileBackedStream = this.sharedSerializedAppendEntriesStreams.get(logIndex);
        if (fileBackedStream == null) {
            fileBackedStream = this.context.getFileBackedOutputStreamFactory().newSharedInstance();
            AppendEntries appendEntries = new AppendEntries(this.currentTerm(), this.context.getId(), this.getLogEntryIndex(followerNextIndex - 1L), this.getLogEntryTerm(followerNextIndex - 1L), entries, this.context.getCommitIndex(), this.getReplicatedToAllIndex(), this.context.getPayloadVersion());
            this.log.debug("{}: Serializing {} for slicing for follower {}", new Object[]{this.logName(), appendEntries, followerLogInfo.getId()});
            try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)fileBackedStream);){
                out.writeObject(appendEntries);
            }
            catch (IOException e) {
                this.log.error("{}: Error serializing {}", new Object[]{this.logName(), appendEntries, e});
                fileBackedStream.cleanup();
                return Collections.emptyList();
            }
            this.sharedSerializedAppendEntriesStreams.put(logIndex, fileBackedStream);
            fileBackedStream.setOnCleanupCallback(index -> {
                this.log.debug("{}: On SharedFileBackedOutputStream cleanup for index {}", (Object)this.logName(), index);
                this.sharedSerializedAppendEntriesStreams.remove(index);
            }, (Object)logIndex);
        } else {
            this.log.debug("{}: Reusing SharedFileBackedOutputStream for follower {}", (Object)this.logName(), (Object)followerLogInfo.getId());
            fileBackedStream.incrementUsageCount();
        }
        this.log.debug("{}: Slicing stream for index {}, follower {}", new Object[]{this.logName(), logIndex, followerLogInfo.getId()});
        followerLogInfo.setSlicedLogEntryIndex(logIndex);
        FollowerIdentifier identifier = new FollowerIdentifier(followerLogInfo.getId());
        this.appendEntriesMessageSlicer.slice(SliceOptions.builder().identifier((Identifier)identifier).fileBackedOutputStream((FileBackedOutputStream)fileBackedStream).sendTo(followerActor).replyTo(this.actor()).onFailureCallback(failure -> {
            this.log.error("{}: Error slicing AppendEntries for follower {}", new Object[]{this.logName(), followerLogInfo.getId(), failure});
            followerLogInfo.setSlicedLogEntryIndex(-1L);
        }).build());
        return Collections.emptyList();
    }

    private void sendAppendEntriesToFollower(ActorSelection followerActor, List<ReplicatedLogEntry> entries, FollowerLogInformation followerLogInformation) {
        boolean isInstallingSnaphot = followerLogInformation.getInstallSnapshotState() != null;
        long leaderCommitIndex = isInstallingSnaphot || followerLogInformation.isLogEntrySlicingInProgress() || !followerLogInformation.isFollowerActive() ? -1L : this.context.getCommitIndex();
        long followerNextIndex = followerLogInformation.getNextIndex();
        AppendEntries appendEntries = new AppendEntries(this.currentTerm(), this.context.getId(), this.getLogEntryIndex(followerNextIndex - 1L), this.getLogEntryTerm(followerNextIndex - 1L), entries, leaderCommitIndex, super.getReplicatedToAllIndex(), this.context.getPayloadVersion(), followerLogInformation.getRaftVersion(), followerLogInformation.needsLeaderAddress(this.getId()));
        if (!entries.isEmpty() || this.log.isTraceEnabled()) {
            this.log.debug("{}: Sending AppendEntries to follower {}: {}", new Object[]{this.logName(), followerLogInformation.getId(), appendEntries});
        }
        followerLogInformation.setSentCommitIndex(leaderCommitIndex);
        followerActor.tell((Object)appendEntries, this.actor());
    }

    public boolean initiateCaptureSnapshot(String followerId) {
        FollowerLogInformation followerLogInfo = this.followerToLog.get(followerId);
        if (this.snapshotHolder.isPresent()) {
            ActorSelection followerActor = this.context.getPeerActorSelection(followerId);
            this.sendSnapshotChunk(followerActor, followerLogInfo);
            return true;
        }
        boolean captureInitiated = this.context.getSnapshotManager().captureToInstall(this.context.getReplicatedLog().last(), this.getReplicatedToAllIndex(), followerId);
        if (captureInitiated) {
            followerLogInfo.setLeaderInstallSnapshotState(new LeaderInstallSnapshotState(this.context.getConfigParams().getSnapshotChunkSize(), this.logName()));
        }
        return captureInitiated;
    }

    private boolean canInstallSnapshot(long nextIndex) {
        return nextIndex == -1L || !this.context.getReplicatedLog().isPresent(nextIndex) && this.context.getReplicatedLog().isInSnapshot(nextIndex);
    }

    private void sendInstallSnapshot() {
        this.log.debug("{}: sendInstallSnapshot", (Object)this.logName());
        for (Map.Entry<String, FollowerLogInformation> e : this.followerToLog.entrySet()) {
            String followerId = e.getKey();
            ActorSelection followerActor = this.context.getPeerActorSelection(followerId);
            FollowerLogInformation followerLogInfo = e.getValue();
            if (followerActor == null) continue;
            long nextIndex = followerLogInfo.getNextIndex();
            if (followerLogInfo.getInstallSnapshotState() == null && this.context.getPeerInfo(followerId).getVotingState() != VotingState.VOTING_NOT_INITIALIZED && !this.canInstallSnapshot(nextIndex)) continue;
            this.sendSnapshotChunk(followerActor, followerLogInfo);
        }
    }

    private void sendSnapshotChunk(ActorSelection followerActor, FollowerLogInformation followerLogInfo) {
        if (this.snapshotHolder.isPresent()) {
            LeaderInstallSnapshotState installSnapshotState = followerLogInfo.getInstallSnapshotState();
            if (installSnapshotState == null) {
                installSnapshotState = new LeaderInstallSnapshotState(this.context.getConfigParams().getSnapshotChunkSize(), this.logName());
                followerLogInfo.setLeaderInstallSnapshotState(installSnapshotState);
            }
            try {
                installSnapshotState.setSnapshotBytes(this.snapshotHolder.get().getSnapshotBytes());
                if (!installSnapshotState.canSendNextChunk()) {
                    return;
                }
                byte[] nextSnapshotChunk = installSnapshotState.getNextChunk();
                this.log.debug("{}: next snapshot chunk size for follower {}: {}", new Object[]{this.logName(), followerLogInfo.getId(), nextSnapshotChunk.length});
                int nextChunkIndex = installSnapshotState.incrementChunkIndex();
                Optional<ServerConfigurationPayload> serverConfig = Optional.empty();
                if (installSnapshotState.isLastChunk(nextChunkIndex)) {
                    serverConfig = Optional.ofNullable(this.context.getPeerServerInfo(true));
                }
                this.sendSnapshotChunk(followerActor, followerLogInfo, nextSnapshotChunk, nextChunkIndex, serverConfig);
                this.log.debug("{}: InstallSnapshot sent to follower {}, Chunk: {}/{}", new Object[]{this.logName(), followerActor.path(), installSnapshotState.getChunkIndex(), installSnapshotState.getTotalChunks()});
            }
            catch (IOException e) {
                this.log.warn("{}: Unable to send chunk: {}/{}. Reseting snapshot progress. Snapshot state: {}", new Object[]{this.logName(), installSnapshotState.getChunkIndex(), installSnapshotState.getTotalChunks(), installSnapshotState});
                installSnapshotState.reset();
            }
        }
    }

    private void sendSnapshotChunk(ActorSelection followerActor, FollowerLogInformation followerLogInfo, byte[] snapshotChunk, int chunkIndex, Optional<ServerConfigurationPayload> serverConfig) {
        LeaderInstallSnapshotState installSnapshotState = followerLogInfo.getInstallSnapshotState();
        installSnapshotState.startChunkTimer();
        followerActor.tell((Object)new InstallSnapshot(this.currentTerm(), this.context.getId(), this.snapshotHolder.get().getLastIncludedIndex(), this.snapshotHolder.get().getLastIncludedTerm(), snapshotChunk, chunkIndex, installSnapshotState.getTotalChunks(), OptionalInt.of(installSnapshotState.getLastChunkHashCode()), serverConfig, followerLogInfo.getRaftVersion()), this.actor());
    }

    private boolean resendSnapshotChunk(ActorSelection followerActor, FollowerLogInformation followerLogInfo) {
        if (!this.snapshotHolder.isPresent()) {
            this.log.warn("{}: Attempting to resend snapshot with no snapshot holder present.", (Object)this.logName());
            followerLogInfo.clearLeaderInstallSnapshotState();
            return false;
        }
        LeaderInstallSnapshotState installSnapshotState = followerLogInfo.getInstallSnapshotState();
        installSnapshotState.resetChunkTimer();
        installSnapshotState.markSendStatus(false);
        this.sendSnapshotChunk(followerActor, followerLogInfo);
        return true;
    }

    private void sendHeartBeat() {
        if (!this.followerToLog.isEmpty()) {
            this.log.trace("{}: Sending heartbeat", (Object)this.logName());
            this.sendAppendEntries(this.context.getConfigParams().getHeartBeatInterval().toNanos(), true);
            this.appendEntriesMessageSlicer.checkExpiredSlicedMessageState();
        }
    }

    private void stopHeartBeat() {
        if (this.heartbeatSchedule != null && !this.heartbeatSchedule.isCancelled()) {
            this.heartbeatSchedule.cancel();
        }
    }

    private void scheduleHeartBeat(FiniteDuration interval) {
        if (this.followerToLog.isEmpty()) {
            return;
        }
        this.stopHeartBeat();
        this.heartbeatSchedule = this.context.getActorSystem().scheduler().scheduleOnce(interval, this.context.getActor(), (Object)SendHeartBeat.INSTANCE, (ExecutionContext)this.context.getActorSystem().dispatcher(), this.context.getActor());
    }

    @Override
    public void close() {
        this.stopHeartBeat();
        this.appendEntriesMessageSlicer.close();
    }

    @Override
    public final String getLeaderId() {
        return this.context.getId();
    }

    @Override
    public final short getLeaderPayloadVersion() {
        return this.context.getPayloadVersion();
    }

    protected boolean isLeaderIsolated() {
        int minPresent = this.getMinIsolatedLeaderPeerCount();
        for (FollowerLogInformation followerLogInformation : this.followerToLog.values()) {
            PeerInfo peerInfo = this.context.getPeerInfo(followerLogInformation.getId());
            if (peerInfo == null || !peerInfo.isVoting() || !followerLogInformation.isFollowerActive() || --minPresent != 0) continue;
            return false;
        }
        return minPresent != 0;
    }

    public String printFollowerStates() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (FollowerLogInformation followerLogInformation : this.followerToLog.values()) {
            sb.append('{');
            sb.append(followerLogInformation.getId());
            sb.append(" state:");
            sb.append(followerLogInformation.isFollowerActive());
            sb.append("},");
        }
        sb.append(']');
        return sb.toString();
    }

    @VisibleForTesting
    public FollowerLogInformation getFollower(String followerId) {
        return this.followerToLog.get(followerId);
    }

    @VisibleForTesting
    public int followerLogSize() {
        return this.followerToLog.size();
    }

    static class SnapshotHolder {
        private final long lastIncludedTerm;
        private final long lastIncludedIndex;
        private final ByteSource snapshotBytes;

        SnapshotHolder(Snapshot snapshot, ByteSource snapshotBytes) {
            this.lastIncludedTerm = snapshot.getLastAppliedTerm();
            this.lastIncludedIndex = snapshot.getLastAppliedIndex();
            this.snapshotBytes = snapshotBytes;
        }

        long getLastIncludedTerm() {
            return this.lastIncludedTerm;
        }

        long getLastIncludedIndex() {
            return this.lastIncludedIndex;
        }

        ByteSource getSnapshotBytes() {
            return this.snapshotBytes;
        }
    }
}

