/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class SS
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Snapshot snapshot;

    public SS() {
    }

    SS(Snapshot snapshot) {
        this.snapshot = Objects.requireNonNull(snapshot);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WritableObjects.writeLongs((DataOutput)out, (long)this.snapshot.getLastIndex(), (long)this.snapshot.getLastTerm());
        WritableObjects.writeLongs((DataOutput)out, (long)this.snapshot.getLastAppliedIndex(), (long)this.snapshot.getLastAppliedTerm());
        WritableObjects.writeLong((DataOutput)out, (long)this.snapshot.getElectionTerm());
        out.writeObject(this.snapshot.getElectionVotedFor());
        out.writeObject(this.snapshot.getServerConfiguration());
        List<ReplicatedLogEntry> unAppliedEntries = this.snapshot.getUnAppliedEntries();
        out.writeInt(unAppliedEntries.size());
        for (ReplicatedLogEntry e : unAppliedEntries) {
            WritableObjects.writeLongs((DataOutput)out, (long)e.getIndex(), (long)e.getTerm());
            out.writeObject(e.getData());
        }
        out.writeObject(this.snapshot.getState());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        long lastIndex = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long lastTerm = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        hdr = WritableObjects.readLongHeader((DataInput)in);
        long lastAppliedIndex = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long lastAppliedTerm = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        long electionTerm = WritableObjects.readLong((DataInput)in);
        String electionVotedFor = (String)in.readObject();
        ServerConfigurationPayload serverConfig = (ServerConfigurationPayload)in.readObject();
        int size = in.readInt();
        ArrayList<ReplicatedLogEntry> unAppliedEntries = new ArrayList<ReplicatedLogEntry>(size);
        for (int i = 0; i < size; ++i) {
            hdr = WritableObjects.readLongHeader((DataInput)in);
            unAppliedEntries.add(new SimpleReplicatedLogEntry(WritableObjects.readFirstLong((DataInput)in, (byte)hdr), WritableObjects.readSecondLong((DataInput)in, (byte)hdr), (Payload)in.readObject()));
        }
        Snapshot.State state = (Snapshot.State)in.readObject();
        this.snapshot = Snapshot.create(state, unAppliedEntries, lastIndex, lastTerm, lastAppliedIndex, lastAppliedTerm, electionTerm, electionVotedFor, serverConfig);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.snapshot);
    }
}

