/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;

public final class SimpleReplicatedLogEntry
implements ReplicatedLogEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = SerializationUtils.serialize((Serializable)new Proxy()).length;
    private final long index;
    private final long term;
    private final Payload payload;
    private boolean persistencePending;

    public SimpleReplicatedLogEntry(long index, long term, Payload payload) {
        this.index = index;
        this.term = term;
        this.payload = Objects.requireNonNull(payload);
    }

    @Override
    public Payload getData() {
        return this.payload;
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public int size() {
        return this.payload.size();
    }

    @Override
    public int serializedSize() {
        return PROXY_SIZE + this.payload.serializedSize();
    }

    @Override
    public boolean isPersistencePending() {
        return this.persistencePending;
    }

    @Override
    public void setPersistencePending(boolean pending) {
        this.persistencePending = pending;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.payload.hashCode();
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleReplicatedLogEntry other = (SimpleReplicatedLogEntry)obj;
        return this.index == other.index && this.term == other.term && this.payload.equals(other.payload);
    }

    public String toString() {
        return "SimpleReplicatedLogEntry [index=" + this.index + ", term=" + this.term + ", payload=" + this.payload + "]";
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private long index;
        private long term;
        private Payload data;

        public Proxy() {
        }

        Proxy(SimpleReplicatedLogEntry replicatedLogEntry) {
            this.index = replicatedLogEntry.getIndex();
            this.term = replicatedLogEntry.getTerm();
            this.data = replicatedLogEntry.getData();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.index);
            out.writeLong(this.term);
            out.writeObject(this.data);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readLong();
            this.term = in.readLong();
            this.data = (Payload)in.readObject();
        }

        private Object readResolve() {
            return new SimpleReplicatedLogEntry(this.index, this.term, this.data);
        }
    }
}

