/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import akka.actor.ExtendedActorSystem;
import akka.serialization.JSerializer;
import akka.util.ClassLoaderObjectInputStream;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReplicatedLogEntrySerializer
extends JSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleReplicatedLogEntrySerializer.class);
    private final ExtendedActorSystem system;

    public SimpleReplicatedLogEntrySerializer(ExtendedActorSystem system) {
        this.system = Objects.requireNonNull(system);
    }

    public int identifier() {
        return 97439500;
    }

    public boolean includeManifest() {
        return false;
    }

    public byte[] toBinary(Object obj) {
        Preconditions.checkArgument((boolean)(obj instanceof SimpleReplicatedLogEntry), (String)"Unsupported object type %s", obj.getClass());
        SimpleReplicatedLogEntry replicatedLogEntry = (SimpleReplicatedLogEntry)obj;
        int estimatedSerializedSize = replicatedLogEntry.serializedSize();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(estimatedSerializedSize);
        SerializationUtils.serialize((Serializable)replicatedLogEntry, (OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        LOG.debug("Estimated serialized size {}, data size {} for payload: {}. Actual serialized size: {}", new Object[]{estimatedSerializedSize, replicatedLogEntry.getData().size(), replicatedLogEntry.getData(), bytes.length});
        return bytes;
    }

    public Object fromBinaryJava(byte[] bytes, Class<?> manifest) {
        Object object;
        ClassLoaderObjectInputStream is = new ClassLoaderObjectInputStream(this.system.dynamicAccess().classLoader(), (InputStream)new ByteArrayInputStream(bytes));
        try {
            object = is.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException("Failed to deserialize object", e);
            }
        }
        is.close();
        return object;
    }
}

