/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.ri.generated.type.builder;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.mdsal.binding.model.api.AbstractType;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.TypeComment;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.AbstractGeneratedTypeBuilder;

abstract class AbstractGeneratedType
extends AbstractType
implements GeneratedType {
    private final TypeComment comment;
    private final List<AnnotationType> annotations;
    private final List<Type> implementsTypes;
    private final List<Enumeration> enumerations;
    private final List<Constant> constants;
    private final List<MethodSignature> methodSignatures;
    private final List<GeneratedType> enclosedTypes;
    private final List<GeneratedProperty> properties;
    private final boolean isAbstract;
    private final YangSourceDefinition definition;

    AbstractGeneratedType(AbstractGeneratedTypeBuilder<?> builder) {
        super((JavaTypeName)builder.getIdentifier());
        this.comment = builder.getComment();
        this.annotations = AbstractGeneratedType.toUnmodifiableAnnotations(builder.getAnnotations());
        this.implementsTypes = AbstractGeneratedType.makeUnmodifiable(builder.getImplementsTypes());
        this.constants = AbstractGeneratedType.makeUnmodifiable(builder.getConstants());
        this.enumerations = List.copyOf(builder.getEnumerations());
        this.methodSignatures = this.toUnmodifiableMethods(builder.getMethodDefinitions());
        this.enclosedTypes = List.copyOf(builder.getEnclosedTransferObjects());
        this.properties = this.toUnmodifiableProperties(builder.getProperties());
        this.isAbstract = builder.isAbstract();
        this.definition = builder.getYangSourceDefinition().orElse(null);
    }

    AbstractGeneratedType(JavaTypeName identifier, TypeComment comment, List<AnnotationTypeBuilder> annotationBuilders, boolean isAbstract, List<Type> implementsTypes, List<GeneratedTypeBuilder> enclosedGenTypeBuilders, List<GeneratedTOBuilder> enclosedGenTOBuilders, List<EnumBuilder> enumBuilders, List<Constant> constants, List<MethodSignatureBuilder> methodBuilders, List<GeneratedPropertyBuilder> propertyBuilders) {
        super(identifier);
        this.comment = comment;
        this.annotations = AbstractGeneratedType.toUnmodifiableAnnotations(annotationBuilders);
        this.implementsTypes = AbstractGeneratedType.makeUnmodifiable(implementsTypes);
        this.constants = AbstractGeneratedType.makeUnmodifiable(constants);
        this.enumerations = this.toUnmodifiableEnumerations(enumBuilders);
        this.methodSignatures = this.toUnmodifiableMethods(methodBuilders);
        this.enclosedTypes = AbstractGeneratedType.toUnmodifiableEnclosedTypes(enclosedGenTypeBuilders, enclosedGenTOBuilders);
        this.properties = this.toUnmodifiableProperties(propertyBuilders);
        this.isAbstract = isAbstract;
        this.definition = null;
    }

    protected static final <T> List<T> makeUnmodifiable(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        return Collections.unmodifiableList(list);
    }

    protected static <T> Set<T> makeUnmodifiable(Set<T> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private static List<GeneratedType> toUnmodifiableEnclosedTypes(List<GeneratedTypeBuilder> enclosedGenTypeBuilders, List<GeneratedTOBuilder> enclosedGenTOBuilders) {
        ArrayList<Object> enclosedTypesList = new ArrayList<Object>(enclosedGenTypeBuilders.size() + enclosedGenTOBuilders.size());
        for (GeneratedTypeBuilder generatedTypeBuilder : enclosedGenTypeBuilders) {
            if (generatedTypeBuilder == null) continue;
            enclosedTypesList.add(generatedTypeBuilder.build());
        }
        for (GeneratedTOBuilder generatedTOBuilder : enclosedGenTOBuilders) {
            if (generatedTOBuilder == null) continue;
            enclosedTypesList.add(generatedTOBuilder.build());
        }
        return AbstractGeneratedType.makeUnmodifiable(enclosedTypesList);
    }

    protected static final List<AnnotationType> toUnmodifiableAnnotations(List<AnnotationTypeBuilder> annotationBuilders) {
        ArrayList<AnnotationType> annotationList = new ArrayList<AnnotationType>(annotationBuilders.size());
        for (AnnotationTypeBuilder builder : annotationBuilders) {
            annotationList.add(builder.build());
        }
        return AbstractGeneratedType.makeUnmodifiable(annotationList);
    }

    protected final List<MethodSignature> toUnmodifiableMethods(List<MethodSignatureBuilder> methodBuilders) {
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>(methodBuilders.size());
        for (MethodSignatureBuilder methodBuilder : methodBuilders) {
            methods.add(methodBuilder.toInstance((Type)this));
        }
        return AbstractGeneratedType.makeUnmodifiable(methods);
    }

    protected final Set<MethodSignature> toUnmodifiableMethods(Set<MethodSignatureBuilder> getters) {
        HashSet<MethodSignature> methods = new HashSet<MethodSignature>(getters.size());
        for (MethodSignatureBuilder methodBuilder : getters) {
            methods.add(methodBuilder.toInstance((Type)this));
        }
        return AbstractGeneratedType.makeUnmodifiable(methods);
    }

    protected final List<Enumeration> toUnmodifiableEnumerations(List<EnumBuilder> enumBuilders) {
        ArrayList<Enumeration> enums = new ArrayList<Enumeration>(enumBuilders.size());
        for (EnumBuilder enumBuilder : enumBuilders) {
            enums.add(enumBuilder.toInstance());
        }
        return AbstractGeneratedType.makeUnmodifiable(enums);
    }

    protected final List<GeneratedProperty> toUnmodifiableProperties(List<GeneratedPropertyBuilder> methodBuilders) {
        ArrayList<GeneratedProperty> methods = new ArrayList<GeneratedProperty>(methodBuilders.size());
        for (GeneratedPropertyBuilder methodBuilder : methodBuilders) {
            methods.add(methodBuilder.toInstance());
        }
        return AbstractGeneratedType.makeUnmodifiable(methods);
    }

    public final TypeComment getComment() {
        return this.comment;
    }

    public final List<AnnotationType> getAnnotations() {
        return this.annotations;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    public final List<Type> getImplements() {
        return this.implementsTypes;
    }

    public final List<GeneratedType> getEnclosedTypes() {
        return this.enclosedTypes;
    }

    public final List<Enumeration> getEnumerations() {
        return this.enumerations;
    }

    public final List<Constant> getConstantDefinitions() {
        return this.constants;
    }

    public final List<MethodSignature> getMethodDefinitions() {
        return this.methodSignatures;
    }

    public final List<GeneratedProperty> getProperties() {
        return this.properties;
    }

    public final Optional<YangSourceDefinition> getYangSourceDefinition() {
        return Optional.ofNullable(this.definition);
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).omitNullValues().add("comment", (Object)this.comment).add("annotations", this.annotations).add("enclosedTypes", this.enclosedTypes).add("enumerations", this.enumerations).add("constants", this.constants).add("methodSignatures", this.methodSignatures);
    }
}

