/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

@Beta
public abstract class AbstractReadTransactionRequest<T extends AbstractReadTransactionRequest<T>>
extends TransactionRequest<T> {
    private static final long serialVersionUID = 1L;
    private final boolean snapshotOnly;

    AbstractReadTransactionRequest(TransactionIdentifier identifier, long sequence, ActorRef replyTo, boolean snapshotOnly) {
        super(identifier, sequence, replyTo);
        this.snapshotOnly = snapshotOnly;
    }

    AbstractReadTransactionRequest(T request, ABIVersion version) {
        super(request, version);
        this.snapshotOnly = ((AbstractReadTransactionRequest)request).isSnapshotOnly();
    }

    public final boolean isSnapshotOnly() {
        return this.snapshotOnly;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("snapshotOnly", this.snapshotOnly);
    }

    @Override
    protected abstract SerialForm<T> externalizableProxy(ABIVersion var1);

    static interface SerialForm<T extends AbstractReadTransactionRequest<T>>
    extends TransactionRequest.SerialForm<T> {
        @Override
        default public T readExternal(ObjectInput in, TransactionIdentifier target, long sequence, ActorRef replyTo) throws IOException {
            return this.readExternal(in, target, sequence, replyTo, in.readBoolean());
        }

        public @NonNull T readExternal(@NonNull ObjectInput var1, @NonNull TransactionIdentifier var2, long var3, @NonNull ActorRef var5, boolean var6) throws IOException;

        @Override
        default public void writeExternal(ObjectOutput out, T msg) throws IOException {
            TransactionRequest.SerialForm.super.writeExternal(out, msg);
            out.writeBoolean(((AbstractReadTransactionRequest)msg).isSnapshotOnly());
        }
    }
}

