/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import java.io.DataInput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.CCF;
import org.opendaylight.controller.cluster.access.commands.ConnectClientFailureProxyV1;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;

@Beta
public final class ConnectClientFailure
extends RequestFailure<ClientIdentifier, ConnectClientFailure> {
    private static final long serialVersionUID = 1L;

    ConnectClientFailure(ClientIdentifier target, long sequence, RequestException cause) {
        super(target, sequence, cause);
    }

    private ConnectClientFailure(ConnectClientFailure failure, ABIVersion version) {
        super(failure, version);
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new CCF(this) : new ConnectClientFailureProxyV1(this);
    }

    @Override
    protected ConnectClientFailure cloneAsVersion(ABIVersion version) {
        return new ConnectClientFailure(this, version);
    }

    static interface SerialForm
    extends RequestFailure.SerialForm<ClientIdentifier, ConnectClientFailure> {
        @Override
        default public ClientIdentifier readTarget(DataInput in) throws IOException {
            return ClientIdentifier.readFrom(in);
        }

        @Override
        default public ConnectClientFailure createFailure(ClientIdentifier target, long sequence, RequestException cause) {
            return new ConnectClientFailure(target, sequence, cause);
        }
    }
}

