/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.CCS;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccessProxyV1;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;

@Beta
public final class ConnectClientSuccess
extends RequestSuccess<ClientIdentifier, ConnectClientSuccess> {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final @NonNull List<ActorSelection> alternates;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="See justification above.")
    private final ReadOnlyDataTree dataTree;
    private final @NonNull ActorRef backend;
    private final int maxMessages;

    private ConnectClientSuccess(ConnectClientSuccess success, ABIVersion version) {
        super(success, version);
        this.alternates = success.alternates;
        this.dataTree = success.dataTree;
        this.backend = success.backend;
        this.maxMessages = success.maxMessages;
    }

    ConnectClientSuccess(ClientIdentifier target, long sequence, ActorRef backend, List<ActorSelection> alternates, int maxMessages, ReadOnlyDataTree dataTree) {
        super(target, sequence);
        this.backend = Objects.requireNonNull(backend);
        this.alternates = ImmutableList.copyOf(alternates);
        this.dataTree = dataTree;
        Preconditions.checkArgument((maxMessages > 0 ? 1 : 0) != 0, (String)"Maximum messages has to be positive, not %s", (int)maxMessages);
        this.maxMessages = maxMessages;
    }

    public ConnectClientSuccess(@NonNull ClientIdentifier target, long sequence, @NonNull ActorRef backend, @NonNull List<ActorSelection> alternates, @NonNull ReadOnlyDataTree dataTree, int maxMessages) {
        this(target, sequence, backend, alternates, maxMessages, Objects.requireNonNull(dataTree));
    }

    public @NonNull List<ActorSelection> getAlternates() {
        return this.alternates;
    }

    public @NonNull ActorRef getBackend() {
        return this.backend;
    }

    public Optional<ReadOnlyDataTree> getDataTree() {
        return Optional.ofNullable(this.dataTree);
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new CCS(this) : new ConnectClientSuccessProxyV1(this);
    }

    @Override
    protected ConnectClientSuccess cloneAsVersion(ABIVersion version) {
        return new ConnectClientSuccess(this, version);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("alternates", this.alternates).add("dataTree present", this.getDataTree().isPresent()).add("maxMessages", this.maxMessages);
    }

    static interface SerialForm
    extends RequestSuccess.SerialForm<ClientIdentifier, ConnectClientSuccess> {
        @Override
        default public ClientIdentifier readTarget(DataInput in) throws IOException {
            return ClientIdentifier.readFrom(in);
        }

        @Override
        default public ConnectClientSuccess readExternal(ObjectInput in, ClientIdentifier target, long sequence) throws IOException, ClassNotFoundException {
            ActorRef backend = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
            int maxMessages = in.readInt();
            int alternatesSize = in.readInt();
            ArrayList<ActorSelection> alternates = new ArrayList<ActorSelection>(alternatesSize);
            for (int i = 0; i < alternatesSize; ++i) {
                alternates.add(ActorSelection.apply((ActorRef)ActorRef.noSender(), (String)((String)in.readObject())));
            }
            return new ConnectClientSuccess(target, sequence, backend, alternates, maxMessages, null);
        }

        @Override
        default public void writeExternal(ObjectOutput out, ConnectClientSuccess msg) throws IOException {
            out.writeObject(Serialization.serializedActorPath((ActorRef)msg.backend));
            out.writeInt(msg.maxMessages);
            out.writeInt(msg.alternates.size());
            for (ActorSelection b : msg.alternates) {
                out.writeObject(b.toSerializationFormat());
            }
        }
    }
}

