/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ETS;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccessProxyV1;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

@Beta
public final class ExistsTransactionSuccess
extends TransactionSuccess<ExistsTransactionSuccess> {
    private static final long serialVersionUID = 1L;
    private final boolean exists;

    private ExistsTransactionSuccess(ExistsTransactionSuccess success, ABIVersion version) {
        super(success, version);
        this.exists = success.exists;
    }

    public ExistsTransactionSuccess(TransactionIdentifier target, long sequence, boolean exists) {
        super(target, sequence);
        this.exists = exists;
    }

    public boolean getExists() {
        return this.exists;
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new ETS(this) : new ExistsTransactionSuccessProxyV1(this);
    }

    @Override
    protected ExistsTransactionSuccess cloneAsVersion(ABIVersion version) {
        return new ExistsTransactionSuccess(this, version);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("exists", this.exists);
    }

    static interface SerialForm
    extends TransactionSuccess.SerialForm<ExistsTransactionSuccess> {
        @Override
        default public ExistsTransactionSuccess readExternal(ObjectInput in, TransactionIdentifier target, long sequence) throws IOException {
            return new ExistsTransactionSuccess(target, sequence, in.readBoolean());
        }

        @Override
        default public void writeExternal(ObjectOutput out, ExistsTransactionSuccess msg) throws IOException {
            out.writeBoolean(msg.getExists());
        }
    }
}

