/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.HS;
import org.opendaylight.controller.cluster.access.commands.LocalHistorySuccessProxyV1;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;

@Beta
public final class LocalHistorySuccess
extends RequestSuccess<LocalHistoryIdentifier, LocalHistorySuccess> {
    private static final long serialVersionUID = 1L;

    private LocalHistorySuccess(LocalHistorySuccess success, ABIVersion version) {
        super(success, version);
    }

    public LocalHistorySuccess(LocalHistoryIdentifier target, long sequence) {
        super(target, sequence);
    }

    @Override
    protected LocalHistorySuccess cloneAsVersion(ABIVersion version) {
        return new LocalHistorySuccess(this, version);
    }

    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new HS(this) : new LocalHistorySuccessProxyV1(this);
    }

    static interface SerialForm
    extends RequestSuccess.SerialForm<LocalHistoryIdentifier, LocalHistorySuccess> {
        @Override
        default public LocalHistoryIdentifier readTarget(DataInput in) throws IOException {
            return LocalHistoryIdentifier.readFrom(in);
        }

        @Override
        default public LocalHistorySuccess readExternal(ObjectInput it, LocalHistoryIdentifier target, long sequence) {
            return new LocalHistorySuccess(target, sequence);
        }
    }
}

