/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.RTS;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccessProxyV1;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.SliceableMessage;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;

@Beta
@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public final class ReadTransactionSuccess
extends TransactionSuccess<ReadTransactionSuccess>
implements SliceableMessage {
    private static final long serialVersionUID = 1L;
    private final Optional<NormalizedNode> data;

    private ReadTransactionSuccess(ReadTransactionSuccess request, ABIVersion version) {
        super(request, version);
        this.data = request.data;
    }

    public ReadTransactionSuccess(TransactionIdentifier identifier, long sequence, Optional<NormalizedNode> data) {
        super(identifier, sequence);
        this.data = Objects.requireNonNull(data);
    }

    public Optional<NormalizedNode> getData() {
        return this.data;
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new RTS(this) : new ReadTransactionSuccessProxyV1(this);
    }

    @Override
    protected ReadTransactionSuccess cloneAsVersion(ABIVersion version) {
        return new ReadTransactionSuccess(this, version);
    }

    static interface SerialForm
    extends TransactionSuccess.SerialForm<ReadTransactionSuccess> {
        @Override
        default public ReadTransactionSuccess readExternal(ObjectInput in, TransactionIdentifier target, long sequence) throws IOException {
            Optional<Object> data = in.readBoolean() ? Optional.of(NormalizedNodeDataInput.newDataInput((DataInput)in).readNormalizedNode()) : Optional.empty();
            return new ReadTransactionSuccess(target, sequence, data);
        }

        @Override
        default public void writeExternal(ObjectOutput out, ReadTransactionSuccess msg) throws IOException {
            TransactionSuccess.SerialForm.super.writeExternal(out, msg);
            Optional<NormalizedNode> data = msg.getData();
            if (data.isPresent()) {
                out.writeBoolean(true);
                try (NormalizedNodeDataOutput nnout = msg.getVersion().getStreamVersion().newDataOutput((DataOutput)out);){
                    nnout.writeNormalizedNode(data.orElseThrow());
                }
            } else {
                out.writeBoolean(false);
            }
        }
    }
}

