/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import java.io.DataInput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.TF;
import org.opendaylight.controller.cluster.access.commands.TransactionFailureProxyV1;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

@Beta
public final class TransactionFailure
extends RequestFailure<TransactionIdentifier, TransactionFailure> {
    private static final long serialVersionUID = 1L;

    private TransactionFailure(TransactionFailure failure, ABIVersion version) {
        super(failure, version);
    }

    TransactionFailure(TransactionIdentifier target, long sequence, RequestException cause) {
        super(target, sequence, cause);
    }

    @Override
    protected TransactionFailure cloneAsVersion(ABIVersion version) {
        return new TransactionFailure(this, version);
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new TF(this) : new TransactionFailureProxyV1(this);
    }

    static interface SerialForm
    extends RequestFailure.SerialForm<TransactionIdentifier, TransactionFailure> {
        @Override
        default public TransactionIdentifier readTarget(DataInput in) throws IOException {
            return TransactionIdentifier.readFrom(in);
        }

        @Override
        default public TransactionFailure createFailure(TransactionIdentifier target, long sequence, RequestException cause) {
            return new TransactionFailure(target, sequence, cause);
        }
    }
}

