/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

public final class LocalHistoryIdentifier
implements WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private final @NonNull ClientIdentifier clientId;
    private final long historyId;
    private final long cookie;

    public LocalHistoryIdentifier(ClientIdentifier frontendId, long historyId) {
        this(frontendId, historyId, 0L);
    }

    public LocalHistoryIdentifier(ClientIdentifier frontendId, long historyId, long cookie) {
        this.clientId = Objects.requireNonNull(frontendId);
        this.historyId = historyId;
        this.cookie = cookie;
    }

    public static @NonNull LocalHistoryIdentifier readFrom(DataInput in) throws IOException {
        ClientIdentifier clientId = ClientIdentifier.readFrom(in);
        byte header = WritableObjects.readLongHeader((DataInput)in);
        return new LocalHistoryIdentifier(clientId, WritableObjects.readFirstLong((DataInput)in, (byte)header), WritableObjects.readSecondLong((DataInput)in, (byte)header));
    }

    public void writeTo(DataOutput out) throws IOException {
        this.clientId.writeTo(out);
        WritableObjects.writeLongs((DataOutput)out, (long)this.historyId, (long)this.cookie);
    }

    public @NonNull ClientIdentifier getClientId() {
        return this.clientId;
    }

    public long getHistoryId() {
        return this.historyId;
    }

    public long getCookie() {
        return this.cookie;
    }

    public int hashCode() {
        int ret = this.clientId.hashCode();
        ret = 31 * ret + Long.hashCode(this.historyId);
        ret = 31 * ret + Long.hashCode(this.cookie);
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocalHistoryIdentifier)) {
            return false;
        }
        LocalHistoryIdentifier other = (LocalHistoryIdentifier)obj;
        return this.historyId == other.historyId && this.cookie == other.cookie && this.clientId.equals(other.clientId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(LocalHistoryIdentifier.class).add("client", (Object)this.clientId).add("history", (Object)Long.toUnsignedString(this.historyId, 16)).add("cookie", (Object)Long.toUnsignedString(this.cookie, 16)).toString();
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private LocalHistoryIdentifier identifier;

        public Proxy() {
        }

        Proxy(LocalHistoryIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        public LocalHistoryIdentifier identifier() {
            return (LocalHistoryIdentifier)Verify.verifyNotNull((Object)this.identifier);
        }

        @Override
        public void setIdentifier(LocalHistoryIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        public Object readResolve() {
            return this.identifier();
        }
    }

    static interface SerialForm
    extends Externalizable {
        public @NonNull LocalHistoryIdentifier identifier();

        public void setIdentifier(@NonNull LocalHistoryIdentifier var1);

        public Object readResolve();

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            LocalHistoryIdentifier id = this.identifier();
            id.getClientId().writeTo(out);
            WritableObjects.writeLongs((DataOutput)out, (long)id.getHistoryId(), (long)id.getCookie());
        }

        @Override
        default public void readExternal(ObjectInput in) throws IOException {
            ClientIdentifier clientId = ClientIdentifier.readFrom(in);
            byte header = WritableObjects.readLongHeader((DataInput)in);
            long historyId = WritableObjects.readFirstLong((DataInput)in, (byte)header);
            long cookie = WritableObjects.readSecondLong((DataInput)in, (byte)header);
            this.setIdentifier(new LocalHistoryIdentifier(clientId, historyId, cookie));
        }
    }
}

