/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

@Beta
public abstract class Message<T extends WritableIdentifier, C extends Message<T, C>>
implements Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull ABIVersion version;
    private final long sequence;
    private final @NonNull T target;

    private Message(ABIVersion version, T target, long sequence) {
        this.target = (WritableIdentifier)Objects.requireNonNull(target);
        this.version = Objects.requireNonNull(version);
        this.sequence = sequence;
    }

    Message(T target, long sequence) {
        this(ABIVersion.current(), target, sequence);
    }

    Message(C msg, ABIVersion version) {
        this(version, ((Message)msg).getTarget(), ((Message)msg).getSequence());
    }

    public final @NonNull T getTarget() {
        return this.target;
    }

    public final long getSequence() {
        return this.sequence;
    }

    @VisibleForTesting
    public final @NonNull ABIVersion getVersion() {
        return this.version;
    }

    public final @NonNull C toVersion(@NonNull ABIVersion toVersion) {
        if (this.version == toVersion) {
            return (C)this;
        }
        switch (toVersion) {
            case BORON: 
            case NEON_SR2: 
            case SODIUM_SR1: 
            case MAGNESIUM: 
            case CHLORINE_SR2: {
                return (C)((Message)Verify.verifyNotNull(this.cloneAsVersion(toVersion)));
            }
        }
        throw new IllegalArgumentException("Unhandled ABI version " + toVersion);
    }

    protected abstract @NonNull C cloneAsVersion(@NonNull ABIVersion var1);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper addToStringAttributes(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("target", this.target).add("sequence", (Object)Long.toUnsignedString(this.sequence));
    }

    protected abstract @NonNull SerialForm<T, C> externalizableProxy(@NonNull ABIVersion var1);

    protected final Object writeReplace() {
        return this.externalizableProxy(this.version);
    }

    protected static interface SerialForm<T extends WritableIdentifier, C extends Message<T, C>>
    extends Externalizable {
        public @NonNull C message();

        public void setMessage(@NonNull C var1);

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            C message = this.message();
            ((Message)message).getTarget().writeTo((DataOutput)out);
            WritableObjects.writeLong((DataOutput)out, (long)((Message)message).getSequence());
            this.writeExternal(out, message);
        }

        public void writeExternal(@NonNull ObjectOutput var1, @NonNull C var2) throws IOException;

        @Override
        default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            WritableIdentifier target = (WritableIdentifier)Verify.verifyNotNull(this.readTarget(in));
            long sequence = WritableObjects.readLong((DataInput)in);
            this.setMessage((Message)Verify.verifyNotNull(this.readExternal(in, target, sequence)));
        }

        public @NonNull C readExternal(@NonNull ObjectInput var1, @NonNull T var2, long var3) throws IOException, ClassNotFoundException;

        public Object readResolve();

        public @NonNull T readTarget(@NonNull DataInput var1) throws IOException;
    }
}

