/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class Request<T extends WritableIdentifier, C extends Request<T, C>>
extends Message<T, C> {
    private static final long serialVersionUID = 1L;
    private final @NonNull ActorRef replyTo;

    protected Request(@NonNull T target, long sequence, @NonNull ActorRef replyTo) {
        super(target, sequence);
        this.replyTo = Objects.requireNonNull(replyTo);
    }

    protected Request(@NonNull C request, @NonNull ABIVersion version) {
        super(request, version);
        this.replyTo = Objects.requireNonNull(((Request)request).getReplyTo());
    }

    public final @NonNull ActorRef getReplyTo() {
        return this.replyTo;
    }

    public abstract @NonNull RequestFailure<T, ?> toRequestFailure(@NonNull RequestException var1);

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("replyTo", (Object)this.replyTo);
    }

    @Override
    protected abstract SerialForm<T, C> externalizableProxy(ABIVersion var1);

    protected static interface SerialForm<T extends WritableIdentifier, C extends Request<T, C>>
    extends Message.SerialForm<T, C> {
        @Override
        default public C readExternal(ObjectInput in, T target, long sequence) throws ClassNotFoundException, IOException {
            return this.readExternal(in, target, sequence, ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject()));
        }

        public @NonNull C readExternal(@NonNull ObjectInput var1, @NonNull T var2, long var3, @NonNull ActorRef var5) throws IOException;

        @Override
        default public void writeExternal(ObjectOutput out, C msg) throws IOException {
            out.writeObject(Serialization.serializedActorPath((ActorRef)((Request)msg).getReplyTo()));
        }
    }
}

