/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

@Beta
public final class TransactionIdentifier
implements WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private final @NonNull LocalHistoryIdentifier historyId;
    private final long transactionId;
    private String shortString;

    public TransactionIdentifier(@NonNull LocalHistoryIdentifier historyId, long transactionId) {
        this.historyId = Objects.requireNonNull(historyId);
        this.transactionId = transactionId;
    }

    public static @NonNull TransactionIdentifier readFrom(DataInput in) throws IOException {
        LocalHistoryIdentifier historyId = LocalHistoryIdentifier.readFrom(in);
        return new TransactionIdentifier(historyId, WritableObjects.readLong((DataInput)in));
    }

    public void writeTo(DataOutput out) throws IOException {
        this.historyId.writeTo(out);
        WritableObjects.writeLong((DataOutput)out, (long)this.transactionId);
    }

    public @NonNull LocalHistoryIdentifier getHistoryId() {
        return this.historyId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        return this.historyId.hashCode() * 31 + Long.hashCode(this.transactionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransactionIdentifier)) {
            return false;
        }
        TransactionIdentifier other = (TransactionIdentifier)obj;
        return this.transactionId == other.transactionId && this.historyId.equals(other.historyId);
    }

    public String toShortString() {
        if (this.shortString == null) {
            String histStr = this.historyId.getHistoryId() == 0L ? "" : "-chn-" + this.historyId.getHistoryId();
            this.shortString = this.historyId.getClientId().getFrontendId().getMemberName().getName() + "-" + this.historyId.getClientId().getFrontendId().getClientType().getName() + "-fe-" + this.historyId.getClientId().getGeneration() + histStr + "-txn-" + this.transactionId + "-" + this.historyId.getCookie();
        }
        return this.shortString;
    }

    public String toString() {
        return this.toShortString();
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private TransactionIdentifier identifier;

        public Proxy() {
        }

        Proxy(TransactionIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        public @NonNull TransactionIdentifier identifier() {
            return (TransactionIdentifier)Verify.verifyNotNull((Object)this.identifier);
        }

        @Override
        public void setIdentifier(TransactionIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        public Object readResolve() {
            return this.identifier();
        }
    }

    static interface SerialForm
    extends Externalizable {
        public @NonNull TransactionIdentifier identifier();

        public void setIdentifier(@NonNull TransactionIdentifier var1);

        public Object readResolve();

        @Override
        default public void readExternal(ObjectInput in) throws IOException {
            this.setIdentifier(new TransactionIdentifier(LocalHistoryIdentifier.readFrom(in), WritableObjects.readLong((DataInput)in)));
        }

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            TransactionIdentifier id = this.identifier();
            id.getHistoryId().writeTo(out);
            WritableObjects.writeLong((DataOutput)out, (long)id.getTransactionId());
        }
    }
}

