/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MakeLeaderLocalInput;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MakeLeaderLocalInputBuilder {
    private DataStoreType _dataStoreType;
    private String _shardName;
    Map<Class<? extends Augmentation<MakeLeaderLocalInput>>, Augmentation<MakeLeaderLocalInput>> augmentation = Map.of();

    public MakeLeaderLocalInputBuilder() {
    }

    public MakeLeaderLocalInputBuilder(DatastoreShardId arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
    }

    public MakeLeaderLocalInputBuilder(MakeLeaderLocalInput base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeLeaderLocalInput>>, Augmentation<MakeLeaderLocalInput>>(aug);
        }
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DatastoreShardId) {
            this._shardName = ((DatastoreShardId)arg).getShardName();
            this._dataStoreType = ((DatastoreShardId)arg).getDataStoreType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[DatastoreShardId]");
    }

    public DataStoreType getDataStoreType() {
        return this._dataStoreType;
    }

    public String getShardName() {
        return this._shardName;
    }

    public <E$$ extends Augmentation<MakeLeaderLocalInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MakeLeaderLocalInputBuilder setDataStoreType(DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }

    private static void check_shardNameLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    public MakeLeaderLocalInputBuilder setShardName(String value) {
        if (value != null) {
            MakeLeaderLocalInputBuilder.check_shardNameLength(value);
        }
        this._shardName = value;
        return this;
    }

    public MakeLeaderLocalInputBuilder addAugmentation(Augmentation<MakeLeaderLocalInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeLeaderLocalInput>>, Augmentation<MakeLeaderLocalInput>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MakeLeaderLocalInputBuilder removeAugmentation(Class<? extends Augmentation<MakeLeaderLocalInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MakeLeaderLocalInput build() {
        return new MakeLeaderLocalInputImpl(this);
    }

    private static final class MakeLeaderLocalInputImpl
    extends AbstractAugmentable<MakeLeaderLocalInput>
    implements MakeLeaderLocalInput {
        private final DataStoreType _dataStoreType;
        private final String _shardName;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MakeLeaderLocalInputImpl(MakeLeaderLocalInputBuilder base) {
            super(base.augmentation);
            this._dataStoreType = base.getDataStoreType();
            this._shardName = base.getShardName();
        }

        @Override
        public DataStoreType getDataStoreType() {
            return this._dataStoreType;
        }

        @Override
        public String getShardName() {
            return this._shardName;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MakeLeaderLocalInput.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MakeLeaderLocalInput.bindingEquals(this, obj);
        }

        public String toString() {
            return MakeLeaderLocalInput.bindingToString(this);
        }
    }
}

