/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractEffectiveUnknownSchmemaNode;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;

@Beta
final class YangDataEffectiveStatementImpl
extends AbstractEffectiveUnknownSchmemaNode<String, YangDataStatement>
implements YangDataEffectiveStatement,
YangDataSchemaNode,
EffectiveStatementMixins.DataNodeContainerMixin<String, YangDataStatement> {
    private final @NonNull DataSchemaNode child;

    YangDataEffectiveStatementImpl(EffectiveStmtCtx.Current<String, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, DataSchemaNode child) {
        super((UnknownStatement)((YangDataStatement)stmt.declared()), (Object)((String)stmt.argument()), (CopyableNode)stmt.history(), substatements);
        this.child = Objects.requireNonNull(child);
    }

    public QName getQName() {
        return this.child.getQName();
    }

    public DataSchemaNode dataChildByName(QName name) {
        return name.equals((Object)this.child.getQName()) ? this.child : null;
    }

    public YangDataEffectiveStatement asEffectiveStatement() {
        return this;
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
        if (SchemaTreeAwareEffectiveStatement.SchemaTreeNamespace.class.equals(namespace)) {
            return this.castChild();
        }
        if (DataTreeAwareEffectiveStatement.DataTreeNamespace.class.equals(namespace)) {
            if (this.child instanceof DataTreeEffectiveStatement) {
                return this.castChild();
            }
            Verify.verify((boolean)(this.child instanceof DataTreeAwareEffectiveStatement), (String)"Unexpected child %s", (Object)this.child);
            return Optional.of(((DataTreeAwareEffectiveStatement)this.child).getAll(namespace));
        }
        return super.getNamespaceContents(namespace);
    }

    private <K, V> Optional<Map<K, V>> castChild() {
        return Optional.of(Map.of(this.child.getQName(), this.child));
    }
}

