/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XMLStreamWriterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLStreamWriterUtils.class);
    private static final Set<QName> IDENTITYREF_WARNED = ConcurrentHashMap.newKeySet();

    XMLStreamWriterUtils() {
    }

    String encodeValue(@NonNull ValueWriter writer, @NonNull TypeDefinition<?> type, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        if (type instanceof IdentityrefTypeDefinition) {
            return XMLStreamWriterUtils.encode(writer, (IdentityrefTypeDefinition)type, value, parent);
        }
        if (type instanceof InstanceIdentifierTypeDefinition) {
            return this.encode(writer, (InstanceIdentifierTypeDefinition)type, value);
        }
        if (value instanceof QName && XMLStreamWriterUtils.isIdentityrefUnion(type)) {
            return XMLStreamWriterUtils.encode(writer, (QName)value, parent);
        }
        if (value instanceof YangInstanceIdentifier && this.isInstanceIdentifierUnion(type)) {
            return this.encodeInstanceIdentifier(writer, (YangInstanceIdentifier)value);
        }
        return XMLStreamWriterUtils.serialize(type, value);
    }

    private static boolean isIdentityrefUnion(TypeDefinition<?> type) {
        if (type instanceof UnionTypeDefinition) {
            for (TypeDefinition subtype : ((UnionTypeDefinition)type).getTypes()) {
                if (!(subtype instanceof IdentityrefTypeDefinition) && !XMLStreamWriterUtils.isIdentityrefUnion(subtype)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInstanceIdentifierUnion(TypeDefinition<?> type) {
        if (type instanceof UnionTypeDefinition) {
            for (TypeDefinition subtype : ((UnionTypeDefinition)type).getTypes()) {
                if (!(subtype instanceof InstanceIdentifierTypeDefinition) && !this.isInstanceIdentifierUnion(subtype)) continue;
                return true;
            }
        }
        return false;
    }

    private static String serialize(@NonNull TypeDefinition<?> type, @NonNull Object value) {
        TypeDefinitionAwareCodec codec = TypeDefinitionAwareCodec.from(type);
        if (codec == null) {
            LOG.warn("Failed to find codec for {}, falling back to using stream", type);
            return value.toString();
        }
        try {
            return (String)codec.serialize(value);
        }
        catch (ClassCastException e) {
            LOG.warn("Provided node value {} did not have type {} required by mapping. Using stream instead.", new Object[]{value, type, e});
            return value.toString();
        }
    }

    @VisibleForTesting
    static String encode(@NonNull ValueWriter writer, @NonNull QName qname, QNameModule parent) throws XMLStreamException {
        if (qname.getNamespace().equals((Object)parent.getNamespace())) {
            return qname.getLocalName();
        }
        String ns = qname.getNamespace().toString();
        String prefix = "x";
        writer.writeNamespace("x", ns);
        return "x:" + qname.getLocalName();
    }

    private static String encode(@NonNull ValueWriter writer, @NonNull IdentityrefTypeDefinition type, @NonNull Object value, QNameModule parent) throws XMLStreamException {
        if (value instanceof QName) {
            return XMLStreamWriterUtils.encode(writer, (QName)value, parent);
        }
        QName qname = type.getQName();
        if (IDENTITYREF_WARNED.add(qname)) {
            LOG.warn("Value of {}:{} is not a QName but {}. Please the source of this data", new Object[]{qname.getNamespace(), qname.getLocalName(), value.getClass(), new Throwable()});
        }
        return value.toString();
    }

    private String encode(@NonNull ValueWriter writer, @NonNull InstanceIdentifierTypeDefinition type, @NonNull Object value) throws XMLStreamException {
        if (value instanceof YangInstanceIdentifier) {
            return this.encodeInstanceIdentifier(writer, (YangInstanceIdentifier)value);
        }
        QName qname = type.getQName();
        LOG.warn("Value of {}:{} is not an InstanceIdentifier but {}", new Object[]{qname.getNamespace(), qname.getLocalName(), value.getClass()});
        return value.toString();
    }

    abstract String encodeInstanceIdentifier(@NonNull ValueWriter var1, YangInstanceIdentifier var2) throws XMLStreamException;
}

