/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractModelStatement;

@Beta
public abstract class AbstractDeclaredStatement<A>
extends AbstractModelStatement<A>
implements DeclaredStatement<A> {
    public ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
        return ImmutableList.of();
    }

    protected static final @NonNull ImmutableList<? extends DeclaredStatement<?>> unmaskList(@NonNull Object masked) {
        return AbstractDeclaredStatement.unmaskList(masked, DeclaredStatement.class);
    }

    public static abstract class WithoutArgument
    extends AbstractDeclaredStatement<Empty> {
        public final Empty argument() {
            return Empty.value();
        }

        public final String rawArgument() {
            return null;
        }

        public static abstract class WithSubstatements
        extends WithoutArgument {
            private final @NonNull Object substatements;

            protected WithSubstatements(ImmutableList<? extends DeclaredStatement<?>> substatements) {
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class ArgumentToString<A>
    extends AbstractDeclaredStatement<A> {
        private final @NonNull A argument;

        protected ArgumentToString(@NonNull A argument) {
            this.argument = Objects.requireNonNull(argument);
        }

        public final A argument() {
            return this.argument;
        }

        public final String rawArgument() {
            return this.argument.toString();
        }

        public static abstract class WithSubstatements<A>
        extends ArgumentToString<A> {
            private final @NonNull Object substatements;

            protected WithSubstatements(A argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(argument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithArgument<A>
    extends WithRawArgument<A> {
        private final @NonNull A argument;

        protected WithArgument(String rawArgument, A argument) {
            super(rawArgument);
            this.argument = Objects.requireNonNull(argument);
        }

        public final A argument() {
            return this.argument;
        }

        public static abstract class WithSubstatements<A>
        extends WithArgument<A> {
            private final @NonNull Object substatements;

            protected WithSubstatements(String rawArgument, A argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(rawArgument, argument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithRawStringArgument
    extends WithRawArgument<String> {
        protected WithRawStringArgument(String rawArgument) {
            super((String)Verify.verifyNotNull((Object)rawArgument));
        }

        public final String argument() {
            return (String)Verify.verifyNotNull((Object)this.rawArgument());
        }

        public static abstract class WithSubstatements
        extends WithRawStringArgument {
            private final @NonNull Object substatements;

            protected WithSubstatements(String rawArgument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(rawArgument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithQNameArgument
    extends AbstractDeclaredStatement<QName> {
        private final @NonNull QName argument;

        protected WithQNameArgument(QName argument) {
            this.argument = Objects.requireNonNull(argument);
        }

        public final QName argument() {
            return this.argument;
        }

        public final String rawArgument() {
            return this.argument.getLocalName();
        }

        public static abstract class WithSubstatements
        extends WithQNameArgument {
            private final @NonNull Object substatements;

            protected WithSubstatements(QName argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(argument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }

    public static abstract class WithRawArgument<A>
    extends AbstractDeclaredStatement<A> {
        private final String rawArgument;

        protected WithRawArgument(String rawArgument) {
            this.rawArgument = rawArgument;
        }

        public final String rawArgument() {
            return this.rawArgument;
        }

        public static abstract class WithSubstatements<A>
        extends WithRawArgument<A> {
            private final @NonNull Object substatements;

            protected WithSubstatements(String rawArgument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
                super(rawArgument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends DeclaredStatement<?>> declaredSubstatements() {
                return WithSubstatements.unmaskList(this.substatements);
            }
        }
    }
}

