/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespacedEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractModelStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.SingletonNamespace;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;

abstract class AbstractEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractModelStatement<A>
implements EffectiveStatement<A, D> {
    AbstractEffectiveStatement() {
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Optional<V> get(Class<N> namespace, K identifier) {
        return Optional.ofNullable(this.getAll(namespace).get(Objects.requireNonNull(identifier)));
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
        Optional<Map<K, V>> ret = this.getNamespaceContents(Objects.requireNonNull(namespace));
        return ret.isPresent() ? ret.get() : ImmutableMap.of();
    }

    public ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return ImmutableList.of();
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(@NonNull Class<N> namespace) {
        return Optional.empty();
    }

    protected static final @NonNull ImmutableList<? extends @NonNull EffectiveStatement<?, ?>> unmaskList(@NonNull Object masked) {
        return AbstractEffectiveStatement.unmaskList(masked, EffectiveStatement.class);
    }

    protected static @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> createSchemaTreeNamespace(Collection<? extends EffectiveStatement<?, ?>> substatements) {
        LinkedHashMap schemaChildren = new LinkedHashMap();
        substatements.stream().filter(SchemaTreeEffectiveStatement.class::isInstance).forEach(child -> AbstractEffectiveStatement.putChild(schemaChildren, (SchemaTreeEffectiveStatement)child, "schema tree"));
        return schemaChildren;
    }

    protected static @NonNull Map<QName, DataTreeEffectiveStatement<?>> createDataTreeNamespace(Collection<SchemaTreeEffectiveStatement<?>> schemaTreeStatements, Map<QName, SchemaTreeEffectiveStatement<?>> schemaTreeNamespace) {
        LinkedHashMap dataChildren = new LinkedHashMap();
        boolean sameAsSchema = true;
        for (SchemaTreeEffectiveStatement<?> child : schemaTreeStatements) {
            if (AbstractEffectiveStatement.indexDataTree(dataChildren, child)) continue;
            sameAsSchema = false;
        }
        return sameAsSchema ? schemaTreeNamespace : AbstractEffectiveStatement.immutableNamespaceOf(dataChildren);
    }

    protected static <T extends SchemaTreeEffectiveStatement<?>> @NonNull Map<QName, T> immutableNamespaceOf(Map<QName, T> map) {
        return map.size() == 1 ? new SingletonNamespace<SchemaTreeEffectiveStatement>((SchemaTreeEffectiveStatement)map.values().iterator().next()) : ImmutableMap.copyOf(map);
    }

    protected static @NonNull HashMap<QName, TypedefEffectiveStatement> createTypedefNamespace(Collection<? extends EffectiveStatement<?, ?>> substatements) {
        HashMap<QName, TypedefEffectiveStatement> typedefs = new HashMap<QName, TypedefEffectiveStatement>();
        substatements.stream().filter(TypedefEffectiveStatement.class::isInstance).forEach(child -> AbstractEffectiveStatement.putChild(typedefs, (TypedefEffectiveStatement)child, "typedef"));
        return typedefs;
    }

    private static boolean indexDataTree(Map<QName, DataTreeEffectiveStatement<?>> map, EffectiveStatement<?, ?> stmt) {
        block5: {
            block4: {
                if (stmt instanceof DataTreeEffectiveStatement) {
                    AbstractEffectiveStatement.putChild(map, (DataTreeEffectiveStatement)stmt, "data tree");
                    return true;
                }
                if (!(stmt instanceof ChoiceEffectiveStatement)) break block4;
                for (EffectiveStatement choiceChild : stmt.effectiveSubstatements()) {
                    if (!(choiceChild instanceof CaseEffectiveStatement)) continue;
                    for (EffectiveStatement caseChild : choiceChild.effectiveSubstatements()) {
                        AbstractEffectiveStatement.indexDataTree(map, caseChild);
                    }
                }
                break block5;
            }
            if (!(stmt instanceof CaseEffectiveStatement)) break block5;
            for (EffectiveStatement child : stmt.effectiveSubstatements()) {
                AbstractEffectiveStatement.indexDataTree(map, child);
            }
        }
        return false;
    }

    private static <T extends NamespacedEffectiveStatement<?>> void putChild(Map<QName, T> map, T child, String namespace) {
        QName id = child.getIdentifier();
        NamespacedEffectiveStatement prev = (NamespacedEffectiveStatement)map.putIfAbsent(id, child);
        if (prev != null) {
            throw new SubstatementIndexingException("Cannot add " + namespace + " child with name " + id + ", a conflicting child already exists");
        }
    }
}

