/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;

final class LinearTypedefNamespace
extends AbstractMap<QName, TypedefEffectiveStatement>
implements Immutable {
    private final Collection<TypedefEffectiveStatement> values;

    LinearTypedefNamespace(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        this.values = Collections2.filter(substatements, TypedefEffectiveStatement.class::isInstance);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(Objects.requireNonNull(value));
    }

    @Override
    public TypedefEffectiveStatement get(Object key) {
        Object nonnull = Objects.requireNonNull(key);
        return this.values().stream().filter(stmt -> nonnull.equals(stmt.argument())).findFirst().orElse(null);
    }

    @Override
    public TypedefEffectiveStatement remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends QName, ? extends TypedefEffectiveStatement> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<QName> keySet() {
        return (Set)this.values.stream().map(ModelStatement::argument).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Collection<TypedefEffectiveStatement> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<QName, TypedefEffectiveStatement>> entrySet() {
        return (Set)this.values.stream().map(stmt -> Map.entry((QName)stmt.argument(), stmt)).collect(ImmutableSet.toImmutableSet());
    }
}

