/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespacedEffectiveStatement;

final class SingletonNamespace<T extends NamespacedEffectiveStatement<?>>
implements Map<QName, T> {
    private final @NonNull T item;

    SingletonNamespace(T item) {
        this.item = (NamespacedEffectiveStatement)Objects.requireNonNull(item);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return key.equals(this.item.argument());
    }

    @Override
    public boolean containsValue(Object value) {
        return value.equals(this.item);
    }

    @Override
    public T get(Object key) {
        return this.containsKey(key) ? (T)this.item : null;
    }

    @Override
    public T put(QName key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends QName, ? extends T> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<QName> keySet() {
        return Set.of((QName)this.item.argument());
    }

    @Override
    public Collection<T> values() {
        return List.of(this.item);
    }

    @Override
    public Set<Map.Entry<QName, T>> entrySet() {
        return Set.of(Map.entry((QName)this.item.argument(), this.item));
    }

    @Override
    public int hashCode() {
        return this.item.getIdentifier().hashCode() ^ this.item.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        Iterator it;
        if (obj == this) {
            return true;
        }
        if (obj instanceof SingletonNamespace) {
            return this.item.equals(((SingletonNamespace)obj).item);
        }
        if (obj instanceof Map && (it = ((Map)obj).entrySet().iterator()).hasNext()) {
            Map.Entry entry = it.next();
            if (!it.hasNext() && ((QName)this.item.argument()).equals(entry.getKey()) && this.item.equals(entry.getValue())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{" + this.item.argument() + "=" + this.item + "}";
    }
}

