/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.connector.ByteBufferPool;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.AuthenticatorService;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.ResourceModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.ops4j.pax.web.service.undertow.internal.ContextAwarePathHandler;
import org.ops4j.pax.web.service.undertow.internal.ResourceServlet;
import org.ops4j.pax.web.service.undertow.internal.ServletContextProxy;
import org.ops4j.pax.web.service.undertow.internal.UndertowUtil;
import org.ops4j.pax.web.utils.ServletContainerInitializerScanner;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.XnioWorker;

public class Context
implements LifeCycle,
HttpHandler,
ResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);
    private final IdentityManager identityManager;
    private final ContextAwarePathHandler path;
    private final ContextModel contextModel;
    private final Set<ServletModel> servlets = new LinkedHashSet<ServletModel>();
    private final Set<WelcomeFileModel> welcomeFiles = new LinkedHashSet<WelcomeFileModel>();
    private final Set<ErrorPageModel> errorPages = new LinkedHashSet<ErrorPageModel>();
    private final Set<EventListenerModel> eventListeners = new LinkedHashSet<EventListenerModel>();
    private final Set<SecurityConstraintMappingModel> securityConstraintMappings = new LinkedHashSet<SecurityConstraintMappingModel>();
    private final Set<FilterModel> filters = new TreeSet<FilterModel>(new FilterRankComparator());
    private final Set<ContainerInitializerModel> containerInitializers = new LinkedHashSet<ContainerInitializerModel>();
    private final List<ServiceRegistration<ServletContext>> registeredServletContexts = new ArrayList<ServiceRegistration<ServletContext>>();
    private final ServletContainer container = ServletContainer.Factory.newInstance();
    private final AtomicBoolean started = new AtomicBoolean();
    private final ClassLoader classLoader;
    private volatile HttpHandler handler;
    private DeploymentManager manager;
    private Bundle undertowBundle;
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private Configuration configuration;
    private XnioWorker wsXnioWorker;
    private int defaultSessionTimeoutInMinutes;
    private SessionPersistenceManager sessionPersistenceManager;

    public Context(IdentityManager identityManager, ContextAwarePathHandler path, ContextModel contextModel) {
        this.identityManager = identityManager;
        this.path = path;
        this.contextModel = contextModel;
        ClassLoader classLoader = contextModel.getClassLoader();
        List bundles = ((ResourceDelegatingBundleClassLoader)classLoader).getBundles();
        BundleClassLoader parentClassLoader = new BundleClassLoader(FrameworkUtil.getBundle(this.getClass()));
        this.classLoader = new ResourceDelegatingBundleClassLoader(bundles, (ClassLoader)parentClassLoader);
        LOG.info("registering context {}, with context path: /{}", (Object)contextModel.getHttpContext(), (Object)contextModel.getContextName());
        this.undertowBundle = FrameworkUtil.getBundle(this.getClass());
        if (this.undertowBundle != null) {
            Filter filterPackage = null;
            try {
                filterPackage = this.undertowBundle.getBundleContext().createFilter("(objectClass=org.osgi.service.packageadmin.PackageAdmin)");
            }
            catch (InvalidSyntaxException e) {
                LOG.error("InvalidSyntaxException while waiting for PackageAdmin Service", (Throwable)e);
            }
            this.packageAdminTracker = new ServiceTracker(this.undertowBundle.getBundleContext(), filterPackage, null);
            this.packageAdminTracker.open();
        }
    }

    public ContextModel getContextModel() {
        return this.contextModel;
    }

    public synchronized void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            LOG.info("Starting context /{}", (Object)this.contextModel.getContextName());
            for (ServletModel servlet : this.servlets) {
                this.doStart(servlet);
            }
            this.createHandler(null);
        }
    }

    public synchronized void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            LOG.info("Stopping context /{}", (Object)this.contextModel.getContextName());
            for (ServletModel servlet : this.servlets) {
                this.doStop(servlet);
            }
            this.destroy();
        }
    }

    private void doStart(ServletModel servlet) throws ServletException {
        this.withPatterns(servlet.getUrlPatterns(), (pattern, handler) -> this.path.addPrefixPath((String)pattern, this), (pattern, handler) -> this.path.addExactPath((String)pattern, this));
    }

    private void doStop(ServletModel servlet) throws ServletException {
        this.withPatterns(servlet.getUrlPatterns(), (pattern, handler) -> {
            if (!"/".equals(pattern) || this.path.getDefaultHandler() == this) {
                this.path.removePrefixPath((String)pattern);
            }
        }, (pattern, handler) -> this.path.removeExactPath((String)pattern));
    }

    private void withPatterns(String[] patterns, BiConsumer<String, HttpHandler> forPrefixPath, BiConsumer<String, HttpHandler> forExactPath) {
        String contextPath = "";
        if (!this.contextModel.getContextName().isEmpty()) {
            contextPath = "/" + this.contextModel.getContextName();
        }
        for (String pattern : patterns) {
            if (pattern.startsWith("/")) {
                pattern = contextPath + pattern;
            } else if (pattern.startsWith("*.")) {
                pattern = contextPath;
            }
            if (pattern.endsWith("/*") || pattern.endsWith("/")) {
                if (pattern.endsWith("/*")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                forPrefixPath.accept(pattern, this);
                continue;
            }
            forExactPath.accept(pattern, this);
        }
    }

    public synchronized void destroy() {
        try {
            LOG.info("destroying context {}, with context path: {}", (Object)this.contextModel.getHttpContext(), (Object)this.contextModel.getContextName());
            this.destroyHandler(false);
        }
        catch (ServletException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (this.wsXnioWorker != null) {
            this.wsXnioWorker.shutdown();
        }
        this.registeredServletContexts.forEach(r -> {
            try {
                r.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.registeredServletContexts.clear();
        this.servlets.forEach(sm -> {
            try {
                this.doStop((ServletModel)sm);
            }
            catch (ServletException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HttpHandler h = this.getHandler(null);
        if (h != null) {
            String path = exchange.getRequestPath();
            if (!this.contextModel.getContextName().isEmpty()) {
                path = path.substring(this.contextModel.getContextName().length() + 1);
            }
            exchange.setRelativePath(path);
            h.handleRequest(exchange);
        } else {
            exchange.setStatusCode(404);
            exchange.endExchange();
        }
    }

    synchronized HttpHandler getHandler(Consumer<ServletContext> consumer) throws ServletException {
        if (this.handler == null) {
            LOG.debug("Creating handler on demand");
            this.createHandler(consumer);
        } else if (consumer != null) {
            consumer.accept((ServletContext)this.manager.getDeployment().getServletContext());
        }
        return this.handler;
    }

    private void createHandler(Consumer<ServletContext> consumer) throws ServletException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.doCreateHandler(consumer);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private synchronized void destroyHandler() throws ServletException {
        this.destroyHandler(true);
    }

    private synchronized void destroyHandler(boolean keepProxy) throws ServletException {
        if (this.manager != null) {
            LOG.debug("Destroying handler for context /{}", (Object)this.contextModel.getContextName());
            if (!keepProxy) {
                this.unregisterServletContext((ServletContext)this.manager.getDeployment().getServletContext());
            }
            LOG.debug("Stopping manager for context /{}", (Object)this.contextModel.getContextName());
            this.manager.stop();
            LOG.debug("Undeploying manager for context /{}", (Object)this.contextModel.getContextName());
            this.manager.undeploy();
            this.manager = null;
            this.handler = null;
        }
    }

    private String getContextPathForOsgi(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        if (contextPath != null && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        } else if (contextPath == null) {
            LOG.warn("ContextPath not found, it's not configured. Assuming '/'");
            contextPath = "/";
        }
        return contextPath;
    }

    /*
     * Exception decompiling
     */
    private void unregisterServletContext(ServletContext servletContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalCondenser.collapseAssignmentsIntoConditional(ConditionalCondenser.java:121)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalCondenser.collapseAssignmentsIntoConditionals(ConditionalCondenser.java:228)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.collapseAssignmentsIntoConditionals(Op03Rewriters.java:44)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:576)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void registerServletContext(ServletContext servletContext, Bundle bundle) {
        Optional<Object> first;
        String webContextPath = this.getContextPathForOsgi(servletContext);
        String filter = String.format("(%s=%s)", "osgi.web.contextpath", webContextPath);
        try {
            first = bundle.getBundleContext().getServiceReferences(ServletContext.class, filter).stream().findFirst();
        }
        catch (InvalidSyntaxException e) {
            LOG.warn("Could not get ServiceReference for ServletContext!", (Throwable)e);
            first = Optional.empty();
        }
        if (!first.isPresent()) {
            Hashtable<String, String> props = new Hashtable<String, String>(2);
            ((Dictionary)props).put("osgi.web.symbolicname", bundle.getSymbolicName());
            ((Dictionary)props).put("osgi.web.contextpath", webContextPath);
            ((Dictionary)props).put("osgi.web.contextname", servletContext.getServletContextName());
            ServiceRegistration serviceReg = bundle.getBundleContext().registerService(ServletContext.class, (Object)new ServletContextProxy(this), props);
            this.registeredServletContexts.add((ServiceRegistration<ServletContext>)serviceReg);
            LOG.debug("ServletContext registered as service with properties: {}", props);
        }
    }

    private void doCreateHandler(Consumer<ServletContext> consumer) throws ServletException {
        SecurityConstraint info;
        LOG.debug("Creating handler for context /{}", (Object)this.contextModel.getContextName());
        WebContainerContext httpContext = this.contextModel.getHttpContext();
        DeploymentInfo deployment = new DeploymentInfo();
        deployment.setEagerFilterInit(true);
        deployment.setDeploymentName(this.contextModel.getContextName());
        deployment.setDisplayName(httpContext.getContextId());
        deployment.setContextPath('/' + this.contextModel.getContextName());
        deployment.setClassLoader(this.classLoader);
        BundleContext bundleContext = this.contextModel.getBundle().getBundleContext();
        if (bundleContext != null) {
            deployment.addServletContextAttribute("osgi-bundlecontext", (Object)bundleContext);
            deployment.addServletContextAttribute("org.springframework.osgi.web.org.osgi.framework.BundleContext", (Object)bundleContext);
        }
        deployment.setResourceManager((ResourceManager)this);
        deployment.setIdentityManager(this.identityManager);
        if (this.contextModel.getRealmName() != null && this.contextModel.getAuthMethod() != null) {
            ServletExtension authenticator = this.getAuthenticator(this.contextModel.getAuthMethod());
            if (authenticator != null) {
                deployment.getServletExtensions().add(authenticator);
            }
            LoginConfig cfg = new LoginConfig(this.contextModel.getAuthMethod(), this.contextModel.getRealmName(), this.contextModel.getFormLoginPage(), this.contextModel.getFormErrorPage());
            deployment.setLoginConfig(cfg);
        }
        boolean defaultServletAdded = false;
        ServletModel fallbackDefaultServlet = null;
        for (ServletModel servletModel : this.servlets) {
            if (servletModel instanceof ResourceModel && "default".equalsIgnoreCase(servletModel.getName())) {
                fallbackDefaultServlet = servletModel;
                LinkedList<String> welcomePages = new LinkedList<String>();
                this.welcomeFiles.forEach(model -> welcomePages.addAll(Arrays.asList(model.getWelcomeFiles())));
                if (welcomePages.size() <= 0) continue;
                ((ResourceServlet)servletModel.getServlet()).configureWelcomeFiles(welcomePages);
                continue;
            }
            ServletInfo info2 = new ServletInfo(servletModel.getName(), Context.clazz(servletModel.getServletClass(), servletModel.getServlet()), Context.factory(servletModel.getServletClass(), servletModel.getServlet()));
            for (Map.Entry param : servletModel.getInitParams().entrySet()) {
                info2.addInitParam((String)param.getKey(), (String)param.getValue());
            }
            info2.addMappings(servletModel.getUrlPatterns());
            boolean bl = defaultServletAdded = servletModel.getUrlPatterns() != null && Arrays.stream(servletModel.getUrlPatterns()).anyMatch("/"::equals);
            if (Boolean.valueOf((String)servletModel.getInitParams().get("async-supported")).booleanValue()) {
                info2.setAsyncSupported(true);
            } else {
                info2.setAsyncSupported(servletModel.getAsyncSupported() != null ? servletModel.getAsyncSupported() : false);
            }
            info2.setLoadOnStartup(Integer.valueOf(servletModel.getLoadOnStartup() != null ? servletModel.getLoadOnStartup() : -1));
            deployment.addServlet(info2);
        }
        if (!defaultServletAdded && fallbackDefaultServlet != null) {
            LOG.info("Adding implicit \"default\" servlet");
            ServletInfo info3 = new ServletInfo(fallbackDefaultServlet.getName(), Context.clazz(fallbackDefaultServlet.getServletClass(), fallbackDefaultServlet.getServlet()), Context.factory(fallbackDefaultServlet.getServletClass(), fallbackDefaultServlet.getServlet()));
            info3.setLoadOnStartup(Integer.valueOf(0));
            this.doStart(fallbackDefaultServlet);
            deployment.addServlet(info3);
        }
        for (WelcomeFileModel welcomeFileModel : this.welcomeFiles) {
            deployment.addWelcomePages(welcomeFileModel.getWelcomeFiles());
        }
        for (ErrorPageModel errorPageModel : this.errorPages) {
            try {
                int error = Integer.parseInt(errorPageModel.getError());
                deployment.addErrorPage(new ErrorPage(errorPageModel.getLocation(), error));
            }
            catch (NumberFormatException nfe) {
                if ("4xx".equals(errorPageModel.getError())) {
                    for (int c = 400; c < 500; ++c) {
                        deployment.addErrorPage(new ErrorPage(errorPageModel.getLocation(), c));
                    }
                    continue;
                }
                if ("5xx".equals(errorPageModel.getError())) {
                    for (int c = 500; c < 600; ++c) {
                        deployment.addErrorPage(new ErrorPage(errorPageModel.getLocation(), c));
                    }
                    continue;
                }
                try {
                    Class<?> clazz = this.classLoader.loadClass(errorPageModel.getError());
                    deployment.addErrorPage(new ErrorPage(errorPageModel.getLocation(), clazz));
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.addSuppressed(nfe);
                    throw new IllegalArgumentException("Unsupported error: " + errorPageModel.getError(), cnfe);
                }
            }
        }
        if (this.contextModel.getContextParams() != null) {
            for (Map.Entry entry : this.contextModel.getContextParams().entrySet()) {
                deployment.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Bundle bundle = this.contextModel.getBundle();
        ServletContainerInitializerScanner servletContainerInitializerScanner = new ServletContainerInitializerScanner(bundle, this.undertowBundle, (PackageAdmin)this.packageAdminTracker.getService());
        HashMap containerInitializers = this.contextModel.getContainerInitializers();
        if (containerInitializers == null) {
            containerInitializers = new HashMap();
            this.contextModel.setContainerInitializers(containerInitializers);
        }
        servletContainerInitializerScanner.scanBundles((Map)containerInitializers);
        for (Map.Entry entry : this.contextModel.getContainerInitializers().entrySet()) {
            deployment.addServletContainerInitalizer(new ServletContainerInitializerInfo(Context.clazz(null, entry.getKey()), Context.factory(null, entry.getKey()), (Set)entry.getValue()));
        }
        for (FilterModel filter : this.filters) {
            info = new FilterInfo(filter.getName(), Context.clazz(filter.getFilterClass(), filter.getFilter()), Context.factory(filter.getFilterClass(), filter.getFilter()));
            for (Map.Entry entry : filter.getInitParams().entrySet()) {
                info.addInitParam((String)entry.getKey(), (String)entry.getValue());
            }
            info.setAsyncSupported(filter.isAsyncSupported());
            deployment.addFilter((FilterInfo)info);
            String[] dispatchers = filter.getDispatcher();
            if (dispatchers == null || dispatchers.length == 0) {
                dispatchers = new String[]{"request"};
            }
            for (String dispatcher : dispatchers) {
                String[] urlPatterns;
                DispatcherType dt = DispatcherType.valueOf((String)dispatcher.toUpperCase());
                String[] servletNames = filter.getServletNames();
                if (servletNames != null) {
                    for (String servletName : servletNames) {
                        deployment.addFilterServletNameMapping(filter.getName(), servletName, dt);
                    }
                }
                if ((urlPatterns = filter.getUrlPatterns()) == null) continue;
                for (String urlPattern : urlPatterns) {
                    deployment.addFilterUrlMapping(filter.getName(), urlPattern, dt);
                }
            }
        }
        for (SecurityConstraintMappingModel securityConstraintMapping : this.securityConstraintMappings) {
            info = new SecurityConstraint();
            info.addRolesAllowed((Collection)securityConstraintMapping.getRoles());
            String dataConstraint = securityConstraintMapping.getDataConstraint();
            if (dataConstraint == null || "NONE".equals(dataConstraint)) {
                info.setTransportGuaranteeType(TransportGuaranteeType.NONE);
            } else if ("INTEGRAL".equals(dataConstraint)) {
                info.setTransportGuaranteeType(TransportGuaranteeType.INTEGRAL);
            } else {
                info.setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL);
            }
            WebResourceCollection webResourceCollection = new WebResourceCollection();
            if (securityConstraintMapping.getMapping() != null) {
                webResourceCollection.addHttpMethod(securityConstraintMapping.getMapping());
            }
            if (securityConstraintMapping.getUrl() != null) {
                webResourceCollection.addUrlPattern(securityConstraintMapping.getUrl());
            }
            info.addWebResourceCollection(webResourceCollection);
            deployment.addSecurityConstraint(info);
        }
        for (EventListenerModel listener : this.eventListeners) {
            info = new ListenerInfo(Context.clazz(null, listener.getEventListener()), Context.factory(null, listener.getEventListener()));
            deployment.addListener((ListenerInfo)info);
        }
        if (this.isJspAvailable()) {
            try {
                Class<?> clazz = this.classLoader.loadClass("org.ops4j.pax.web.jsp.JasperInitializer");
                deployment.addServletContainerInitalizer(new ServletContainerInitializerInfo(clazz, Context.factory(clazz, null), null));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.isWebSocketAvailable()) {
            this.wsXnioWorker = UndertowUtil.createWorker(this.contextModel.getClassLoader());
            if (this.wsXnioWorker != null) {
                deployment.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)new WebSocketDeploymentInfo().setWorker(this.wsXnioWorker).setBuffers((ByteBufferPool)new DefaultByteBufferPool(true, 100)));
            }
        }
        deployment.addInnerHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return exchange -> {
                    ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    if (Context.this.contextModel.getHttpContext().handleSecurity((HttpServletRequest)src.getOriginalRequest(), (HttpServletResponse)src.getOriginalResponse())) {
                        handler.handleRequest(exchange);
                    } else {
                        try {
                            src.getOriginalResponse().sendError(401);
                        }
                        catch (IllegalStateException e) {
                            try {
                                src.getOriginalResponse().setStatus(401);
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
        });
        ServletSessionConfig ssc = new ServletSessionConfig();
        if (this.contextModel.getSessionDomain() != null) {
            ssc.setDomain(this.contextModel.getSessionDomain());
        } else if (this.configuration != null && this.configuration.getSessionDomain() != null) {
            ssc.setDomain(this.configuration.getSessionDomain());
        }
        if (this.contextModel.getSessionCookie() != null) {
            ssc.setName(this.contextModel.getSessionCookie());
        } else if (this.configuration != null && this.configuration.getSessionCookie() != null) {
            ssc.setName(this.configuration.getSessionCookie());
        }
        if (this.contextModel.getSessionCookieHttpOnly() != null) {
            ssc.setHttpOnly(this.contextModel.getSessionCookieHttpOnly().booleanValue());
        } else if (this.configuration != null && this.configuration.getSessionCookieHttpOnly() != null) {
            ssc.setHttpOnly(this.configuration.getSessionCookieHttpOnly().booleanValue());
        }
        if (this.contextModel.getSessionCookieSecure() != null) {
            ssc.setSecure(this.contextModel.getSessionCookieSecure().booleanValue());
        } else if (this.configuration != null && this.configuration.getSessionCookieSecure() != null) {
            ssc.setSecure(this.configuration.getSessionCookieSecure().booleanValue());
        }
        if (this.contextModel.getSessionCookieMaxAge() != null) {
            ssc.setMaxAge(this.contextModel.getSessionCookieMaxAge().intValue());
        } else if (this.configuration != null && this.configuration.getSessionCookieMaxAge() != null) {
            ssc.setMaxAge(this.configuration.getSessionCookieMaxAge().intValue());
        }
        if (this.contextModel.getSessionPath() != null) {
            ssc.setPath(this.contextModel.getSessionPath());
        } else if (this.configuration != null && this.configuration.getSessionPath() != null) {
            ssc.setPath(this.configuration.getSessionPath());
        }
        deployment.setServletSessionConfig(ssc);
        deployment.setDefaultSessionTimeout(this.defaultSessionTimeoutInMinutes * 60);
        deployment.setSessionPersistenceManager(this.sessionPersistenceManager);
        this.manager = this.container.addDeployment(deployment);
        LOG.info("Creating undertow servlet deployment for context path /{}...", (Object)this.contextModel.getContextName());
        this.manager.deploy();
        LOG.info("Creating undertow servlet deployment for context path /{} - done", (Object)this.contextModel.getContextName());
        LOG.info("Registering {} as OSGi service...", (Object)this.manager.getDeployment().getServletContext());
        this.registerServletContext((ServletContext)this.manager.getDeployment().getServletContext(), bundle);
        LOG.info("Registering {} as OSGi service - done", (Object)this.manager.getDeployment().getServletContext());
        if (consumer != null) {
            consumer.accept((ServletContext)this.manager.getDeployment().getServletContext());
        }
        LOG.info("Starting Undertow web application for context path /{}", (Object)this.contextModel.getContextName());
        this.handler = this.manager.start();
    }

    private ServletExtension getAuthenticator(String method) {
        ServiceLoader<AuthenticatorService> sl = ServiceLoader.load(AuthenticatorService.class, this.getClass().getClassLoader());
        for (AuthenticatorService svc : sl) {
            try {
                ServletExtension auth = (ServletExtension)svc.getAuthenticatorService(method, ServletExtension.class);
                if (auth == null) continue;
                return auth;
            }
            catch (Throwable t) {
                LOG.debug("Unable to load AuthenticatorService for: " + method, t);
            }
        }
        return null;
    }

    private static <T> Class<? extends T> clazz(Class<? extends T> clazz, T instance) {
        if (clazz != null) {
            return clazz;
        }
        return instance.getClass();
    }

    private static <T> InstanceFactory<? extends T> factory(Class<? extends T> clazz, T instance) throws ServletException {
        if (instance != null) {
            return new ImmediateInstanceFactory(instance);
        }
        try {
            Constructor<T> cns = clazz.getDeclaredConstructor(new Class[0]);
            cns.setAccessible(true);
            return new ConstructorInstanceFactory(cns);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException("Unable to create factory", (Throwable)e);
        }
    }

    public Resource getResource(String path) throws IOException {
        String realPath;
        URL resource;
        WebContainerContext context = this.contextModel.getHttpContext();
        if (context != null && context.isDefaultOrSharedContext()) {
            URL resource2 = context.getResource(path);
            if (resource2 == null) {
                return null;
            }
            if (resource2.toString().endsWith("/")) {
                return new DirectoryResource(resource2);
            }
            boolean possibleDirectoryBundleEntry = false;
            try (InputStream peek = resource2.openStream();){
                possibleDirectoryBundleEntry = peek.available() == 0;
            }
            if (possibleDirectoryBundleEntry) {
                String realBase = path.endsWith("/") ? path : path + "/";
                URLResource[] indexResource = new URLResource[1];
                this.welcomeFiles.forEach(wfm -> {
                    for (String wf : wfm.getWelcomeFiles()) {
                        URL index = context.getResource(CanonicalPathUtils.canonicalize((String)(realBase + wf)));
                        if (index == null) continue;
                        indexResource[0] = new URLResource(index, path);
                    }
                });
                if (indexResource[0] != null) {
                    return indexResource[0];
                }
            }
            return new URLResource(resource2, path);
        }
        String modPath = path;
        if (modPath.startsWith("/")) {
            modPath = path.substring(1);
        }
        if ((resource = this.classLoader.getResource(realPath = modPath)) == null) {
            return null;
        }
        return new URLResource(resource, path);
    }

    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
    }

    public void close() throws IOException {
    }

    private boolean isJspAvailable() {
        try {
            return JspServletWrapper.class != null;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }

    private boolean isWebSocketAvailable() {
        try {
            return WebSocketDeploymentInfo.class != null;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }

    public synchronized void addServlet(ServletModel model) throws ServletException {
        if (this.servlets.add(model) && this.started.get()) {
            this.destroyHandler();
            this.doStart(model);
        }
    }

    public synchronized void removeServlet(ServletModel model) throws ServletException {
        if (this.servlets.remove(model) && this.started.get()) {
            this.destroyHandler();
            this.doStop(model);
        }
    }

    public synchronized void addWelcomeFile(WelcomeFileModel welcomeFile) throws ServletException {
        if (this.welcomeFiles.add(welcomeFile) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public synchronized void removeWelcomeFile(WelcomeFileModel welcomeFile) throws ServletException {
        if (this.welcomeFiles.remove(welcomeFile) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public synchronized void addErrorPage(ErrorPageModel model) throws ServletException {
        if (this.errorPages.add(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void removeErrorPage(ErrorPageModel model) throws ServletException {
        if (this.errorPages.remove(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void addEventListener(EventListenerModel model) throws ServletException {
        if (this.eventListeners.add(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void removeEventListener(EventListenerModel model) throws ServletException {
        if (this.eventListeners.remove(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void addFilter(FilterModel model) throws ServletException {
        if (this.filters.add(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void removeFilter(FilterModel model) throws ServletException {
        if (this.filters.remove(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void addSecurityConstraintMapping(SecurityConstraintMappingModel model) throws ServletException {
        if (this.securityConstraintMappings.add(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void removeSecurityConstraintMapping(SecurityConstraintMappingModel model) throws ServletException {
        if (this.securityConstraintMappings.remove(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void addContainerInitializerModel(ContainerInitializerModel model) throws ServletException {
        if (this.containerInitializers.add(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void removeContainerInitializerModel(ContainerInitializerModel model) throws ServletException {
        if (this.containerInitializers.remove(model) && this.started.get()) {
            this.destroyHandler();
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDefaultSessionTimeoutInMinutes(int defaultSessionTimeoutInMinutes) {
        this.defaultSessionTimeoutInMinutes = defaultSessionTimeoutInMinutes;
    }

    public void setSessionPersistenceManager(SessionPersistenceManager sessionPersistenceManager) {
        this.sessionPersistenceManager = sessionPersistenceManager;
    }

    private static /* synthetic */ boolean lambda$unregisterServletContext$6(String webContextPath, ServiceRegistration reg) {
        return reg.getReference() != null && webContextPath.equals(reg.getReference().getProperty("osgi.web.contextpath"));
    }

    private class FilterRankComparator
    implements Comparator<FilterModel> {
        private FilterRankComparator() {
        }

        @Override
        public int compare(FilterModel fm1, FilterModel fm2) {
            int r2;
            int r1 = fm1.getInitParams() == null || fm1.getInitParams().get("filterRank") == null ? 0 : Integer.parseInt((String)fm1.getInitParams().get("filterRank"));
            int n = r2 = fm2.getInitParams() == null || fm2.getInitParams().get("filterRank") == null ? 0 : Integer.parseInt((String)fm2.getInitParams().get("filterRank"));
            if (r1 == r2) {
                return fm1.getName().compareTo(fm2.getName());
            }
            return Integer.compare(r1, r2);
        }
    }

    private class DirectoryResource
    implements Resource {
        private final URL url;

        DirectoryResource(URL url) throws IOException {
            this.url = url;
        }

        public String getPath() {
            return this.url.getPath();
        }

        public Date getLastModified() {
            return null;
        }

        public String getLastModifiedString() {
            return null;
        }

        public ETag getETag() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isDirectory() {
            return true;
        }

        public List<Resource> list() {
            try {
                ArrayList<Resource> children = new ArrayList<Resource>();
                WebContainerContext ctx = Context.this.contextModel.getHttpContext();
                Set rps = ctx.getResourcePaths(this.getPath());
                if (rps != null) {
                    for (String child : rps) {
                        children.add(Context.this.getResource(child));
                    }
                }
                return children;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String getContentType(MimeMappings mimeMappings) {
            return null;
        }

        public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
        }

        public Long getContentLength() {
            return null;
        }

        public String getCacheKey() {
            return null;
        }

        public File getFile() {
            return null;
        }

        public File getResourceManagerRoot() {
            return null;
        }

        public URL getUrl() {
            return this.url;
        }

        public Path getFilePath() {
            return null;
        }

        public Path getResourceManagerRootPath() {
            return null;
        }
    }
}

